/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.stomp.broker.impl;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.noear.solon.Utils;
import org.noear.solon.net.stomp.Frame;
import org.noear.solon.net.stomp.StompEmitter;
import org.noear.solon.net.stomp.broker.impl.StompServerOperations;
import org.noear.solon.net.websocket.WebSocket;

public class StompServerEmitter
implements StompEmitter {
    private final StompServerOperations operations;

    protected StompServerEmitter(StompServerOperations operations) {
        this.operations = operations;
    }

    public void sendTo(WebSocket session, Frame frame) {
        assert (frame != null);
        if (session.isValid()) {
            String frameStr = this.operations.getCodec().encode(frame);
            session.send(ByteBuffer.wrap(frameStr.getBytes(StandardCharsets.UTF_8)));
        }
    }

    @Override
    public void sendTo(String destination, Frame frame) {
        assert (frame != null);
        if (Utils.isEmpty((String)destination)) {
            return;
        }
        this.operations.getSubscriptionInfos().parallelStream().filter(subscriptionInfo -> {
            Pattern pattern = this.operations.getDestinationMatchs().get(subscriptionInfo.getDestination());
            if (pattern == null) {
                return false;
            }
            return pattern.matcher(destination).matches();
        }).forEach(subscriptionInfo -> {
            WebSocket sendSocket = this.operations.getSessionMap().get(subscriptionInfo.getSessionId());
            if (sendSocket != null) {
                Frame replyMessage = Frame.newBuilder().command("MESSAGE").payload(frame.getPayload()).header("content-type", frame.getHeader("content-type")).header("destination", subscriptionInfo.getDestination()).header("subscription", subscriptionInfo.getSubscriptionId()).header("message-id", Utils.guid()).build();
                this.sendTo(sendSocket, replyMessage);
            }
        });
    }
}

