/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.stomp;

import java.util.ArrayList;
import java.util.List;
import org.noear.solon.Utils;
import org.noear.solon.core.util.KeyValue;
import org.noear.solon.net.stomp.Frame;
import org.noear.solon.net.stomp.SimpleFrame;

public class FrameBuilder {
    private String command;
    private List<KeyValue<String>> headers = new ArrayList<KeyValue<String>>();
    private String payload;

    public FrameBuilder command(String command) {
        this.command = command;
        return this;
    }

    public FrameBuilder payload(String payload) {
        this.payload = payload;
        return this;
    }

    public FrameBuilder headers(KeyValue<String> ... headers) {
        for (KeyValue<String> header : headers) {
            this.headers.add(header);
        }
        return this;
    }

    public FrameBuilder headers(Iterable<KeyValue<String>> headers) {
        for (KeyValue<String> header : headers) {
            this.headers.add(header);
        }
        return this;
    }

    public FrameBuilder header(String key, String val) {
        if (key != null && val != null) {
            this.headers.add((KeyValue<String>)new KeyValue(key, (Object)val));
        }
        return this;
    }

    public FrameBuilder contentType(String contentType) {
        if (Utils.isNotEmpty((String)contentType)) {
            return this.header("content-type", contentType);
        }
        return this;
    }

    public FrameBuilder destination(String destination) {
        if (Utils.isNotEmpty((String)destination)) {
            return this.header("destination", destination);
        }
        return this;
    }

    public Frame build() {
        return new SimpleFrame(this.command, this.payload, this.headers);
    }
}

