/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.stomp.impl;

import java.util.Iterator;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.noear.solon.core.util.KeyValue;
import org.noear.solon.net.stomp.Message;
import org.noear.solon.net.stomp.StompListener;
import org.noear.solon.net.stomp.impl.DestinationInfo;
import org.noear.solon.net.stomp.impl.StompMessageSenderImpl;
import org.noear.solon.net.websocket.WebSocket;

public final class StompListenerImpl
implements StompListener {
    private final StompMessageSenderImpl messageSender;

    public StompListenerImpl(StompMessageSenderImpl messageSender) {
        this.messageSender = messageSender;
    }

    @Override
    public void onOpen(WebSocket socket) {
        this.messageSender.getOperations().getWebSocketMap().put(socket.id(), socket);
    }

    @Override
    public void onClose(WebSocket socket) {
        this.messageSender.getOperations().getWebSocketMap().remove(socket);
        this.onUnsubscribe(socket, null);
    }

    @Override
    public void onConnect(WebSocket socket, Message message) {
        String heartBeat = message.getHeader("heart-beat");
        Message message1 = Message.newBuilder().command("CONNECTED").headers(new KeyValue("heart-beat", (Object)(heartBeat == null ? "0,0" : heartBeat)), new KeyValue("server", (Object)"stomp"), new KeyValue("version", (Object)"1.2")).build();
        this.messageSender.sendTo(socket, message1);
    }

    @Override
    public void onDisconnect(WebSocket socket, Message message) {
        String receiptId = message.getHeader("receipt");
        Message message1 = Message.newBuilder().command("RECEIPT").header("receipt-id", receiptId).build();
        this.messageSender.sendTo(socket, message1);
    }

    @Override
    public void onSubscribe(WebSocket socket, Message message) {
        String receiptId;
        String subscriptionId = message.getHeader("id");
        String destination = message.getHeader("destination");
        if (destination == null || destination.length() == 0 || subscriptionId == null || subscriptionId.length() == 0) {
            Message message1 = Message.newBuilder().command("ERROR").payload("Required 'destination' or 'id' header missed").build();
            this.messageSender.sendTo(socket, message1);
            return;
        }
        DestinationInfo destinationInfo = new DestinationInfo(socket.id(), destination, subscriptionId);
        this.messageSender.getOperations().getDestinationInfoSet().add(destinationInfo);
        if (!this.messageSender.getOperations().getDestinationMatch().containsKey(destination)) {
            String destinationRegexp = "^" + destination.replaceAll("\\*\\*", ".+").replaceAll("\\*", ".+") + "$";
            this.messageSender.getOperations().getDestinationMatch().put(destination, Pattern.compile(destinationRegexp));
        }
        if ((receiptId = message.getHeader("receipt")) != null) {
            Message message1 = Message.newBuilder().command("RECEIPT").header("receipt-id", receiptId).build();
            this.messageSender.sendTo(socket, message1);
        }
    }

    @Override
    public void onUnsubscribe(WebSocket socket, Message message) {
        String sessionId = socket.id();
        if (message == null) {
            this.unSubscribeHandle(destinationInfo -> sessionId.equals(destinationInfo.getSessionId()));
        } else {
            String subscription = message.getHeader("id");
            String destination = message.getHeader("destination");
            this.unSubscribeHandle(destinationInfo -> sessionId.equals(destinationInfo.getSessionId()) && (destinationInfo.getDestination().equals(destination) || destinationInfo.getSubscription().equals(subscription)));
        }
    }

    @Override
    public void onSend(WebSocket socket, Message message) {
        String destination = message.getHeader("destination");
        if (destination == null || destination.length() == 0) {
            Message message1 = Message.newBuilder().command("ERROR").payload("Required 'destination' header missed").build();
            this.messageSender.sendTo(socket, message1);
        } else {
            Message message1 = Message.newBuilder().payload(message.getPayload()).contentType(message.getHeader("content-type")).build();
            this.messageSender.sendTo(destination, message1);
        }
    }

    @Override
    public void onAck(WebSocket socket, Message message) {
    }

    protected void unSubscribeHandle(Function<DestinationInfo, Boolean> function) {
        Iterator<DestinationInfo> iterator = this.messageSender.getOperations().getDestinationInfoSet().iterator();
        while (iterator.hasNext()) {
            if (!function.apply(iterator.next()).booleanValue()) continue;
            iterator.remove();
        }
    }
}

