/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.stomp.impl;

import java.util.ArrayList;
import java.util.List;
import org.noear.solon.net.stomp.Header;
import org.noear.solon.net.stomp.Message;

public class MessageImpl
implements Message {
    private final String command;
    private final List<Header> headers;
    private final String payload;

    public MessageImpl(String command, String payload) {
        this(command, null, payload);
    }

    public MessageImpl(String command, List<Header> headers) {
        this(command, headers, null);
    }

    public MessageImpl(String command, List<Header> headers, String payload) {
        this.command = command;
        this.headers = headers == null ? new ArrayList() : headers;
        this.payload = payload;
    }

    @Override
    public Message addHeader(String key, String val) {
        this.headers.add(new Header(key, val));
        return this;
    }

    @Override
    public List<Header> getHeaderAll() {
        return this.headers;
    }

    @Override
    public String getHeader(String key) {
        if (this.headers == null) {
            return null;
        }
        for (Header h : this.headers) {
            if (!key.equals(h.getKey())) continue;
            return h.getValue();
        }
        return null;
    }

    @Override
    public String getPayload() {
        return this.payload;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    public String toString() {
        return "Message {command='" + this.command + "', headers=" + this.headers + ", payload='" + this.payload + "'}";
    }
}

