/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.stomp.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.noear.solon.net.stomp.Header;
import org.noear.solon.net.stomp.Message;
import org.noear.solon.net.stomp.impl.MessageCodec;
import org.noear.solon.net.stomp.impl.MessageImpl;

public class MessageCodecImpl
implements MessageCodec {
    private String commandEnd = "\n";
    private String headersEnd = "\n\n";
    private String headerDelimiter = "\n";
    private String headerKvDelimiter = ":";
    private String bodyEnd = "\u0000";
    private final StringBuilder pending = new StringBuilder();

    @Override
    public String encode(Message input) {
        StringBuilder sb = new StringBuilder();
        sb.append(input.getCommand()).append(this.commandEnd);
        List<Header> headers = this.msgHeaders(input);
        int hCnt = headers.size();
        for (int index = 0; index < hCnt; ++index) {
            Header header = headers.get(index);
            sb.append(header.getKey()).append(this.headerKvDelimiter).append(header.getValue());
            if (index >= hCnt - 1) continue;
            sb.append(this.headerDelimiter);
        }
        sb.append(this.headersEnd);
        String payload = input.getPayload();
        if (payload != null) {
            sb.append(payload);
        }
        sb.append(this.bodyEnd);
        return sb.toString();
    }

    protected List<Header> msgHeaders(Message input) {
        List<Header> headers = input.getHeaderAll();
        return new ArrayList<Header>(headers);
    }

    @Override
    public synchronized void decode(String input, Consumer<Message> out) {
        if (input == null || input.isEmpty()) {
            return;
        }
        this.pending.append(input);
        this.decode(out, 0);
    }

    protected void decode(Consumer<Message> out, int start) {
        this.cleanPendingStartData(start);
        int bEndIdx = this.pending.indexOf(this.bodyEnd);
        if (bEndIdx < 0) {
            return;
        }
        int cEndIdx = this.pending.indexOf(this.commandEnd);
        int hEndIdx = this.pending.indexOf(this.headersEnd);
        if (cEndIdx <= 0 || hEndIdx <= cEndIdx || bEndIdx <= hEndIdx) {
            this.decode(out, 1);
            return;
        }
        String command = this.pending.substring(0, cEndIdx).trim();
        if (!this.isCommand(command)) {
            this.decode(out, 1);
            return;
        }
        List<Header> headers = this.decodeHeaders(cEndIdx, hEndIdx);
        String payload = this.pending.substring(hEndIdx + this.headersEnd.length(), bEndIdx);
        out.accept(this.createMessage(command, headers, payload));
        this.decode(out, bEndIdx + this.bodyEnd.length());
    }

    protected void cleanPendingStartData(int start) {
        if (start > 0) {
            this.pending.delete(0, start);
        }
        int index = 0;
        for (int i = 0; i < this.pending.length(); ++i) {
            char c = this.pending.charAt(i);
            if (!this.isCommandChar(c)) continue;
            index = i;
            break;
        }
        if (index > 0) {
            this.pending.delete(0, index);
        }
    }

    protected List<Header> decodeHeaders(int cEndIdx, int hEndIdx) {
        String[] strHeaders = this.pending.substring(cEndIdx + this.commandEnd.length(), hEndIdx).split(this.headerDelimiter);
        ArrayList<Header> headers = new ArrayList<Header>(strHeaders.length);
        for (String header : strHeaders) {
            int start;
            if (header == null || (start = header.indexOf(this.headerKvDelimiter)) < 1) continue;
            headers.add(new Header(header.substring(0, start), header.substring(start + this.headerKvDelimiter.length(), header.length())));
        }
        return headers;
    }

    protected boolean isCommand(String command) {
        return !command.isEmpty() && command.matches("[A-Z]+");
    }

    protected boolean isCommandChar(char c) {
        return c >= 'A' && c <= 'Z';
    }

    protected Message createMessage(String command, List<Header> headers, String payload) {
        return new MessageImpl(command, headers, payload);
    }

    public String getCommandEnd() {
        return this.commandEnd;
    }

    public void setCommandEnd(String commandEnd) {
        if (commandEnd != null) {
            this.commandEnd = commandEnd;
        }
    }

    public String getHeadersEnd() {
        return this.headersEnd;
    }

    public void setHeadersEnd(String headersEnd) {
        if (headersEnd != null) {
            this.headersEnd = headersEnd;
        }
    }

    public String getBodyEnd() {
        return this.bodyEnd;
    }

    public void setBodyEnd(String bodyEnd) {
        if (bodyEnd != null) {
            this.bodyEnd = bodyEnd;
        }
    }

    public String getHeaderDelimiter() {
        return this.headerDelimiter;
    }

    public void setHeaderDelimiter(String headerDelimiter) {
        if (headerDelimiter != null) {
            this.headerDelimiter = headerDelimiter;
        }
    }

    public String getHeaderKvDelimiter() {
        return this.headerKvDelimiter;
    }

    public void setHeaderKvDelimiter(String headerKvDelimiter) {
        if (headerKvDelimiter != null) {
            this.headerKvDelimiter = headerKvDelimiter;
        }
    }
}

