/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.stomp.impl;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.noear.solon.net.stomp.Header;
import org.noear.solon.net.stomp.Message;
import org.noear.solon.net.stomp.impl.MessageImpl;
import org.noear.solon.net.stomp.impl.StompMessageOperations;
import org.noear.solon.net.websocket.WebSocket;

public final class StompMessageSendingTemplate {
    private StompMessageOperations stompMessageOperations;

    public StompMessageSendingTemplate(StompMessageOperations stompMessageOperations) {
        this.stompMessageOperations = stompMessageOperations;
    }

    public void send(WebSocket webSocket, Message message) {
        try {
            if (webSocket.isValid()) {
                webSocket.send(ByteBuffer.wrap(this.stompMessageOperations.getMsgCodec().encode(message).getBytes(StandardCharsets.UTF_8)));
            }
        }
        finally {
            if (!webSocket.isValid()) {
                webSocket.close();
            }
        }
    }

    public void send(String destination, String payload) {
        this.send(destination, payload, null, null);
    }

    public void send(String destination, String payload, List<Header> headers) {
        this.send(destination, payload, null, headers);
    }

    public void send(String destination, String payload, String contentType) {
        this.send(destination, payload, contentType, null);
    }

    public void send(String destination, String payload, String contentType, List<Header> headers) {
        this.stompMessageOperations.getDestinationInfoSet().parallelStream().filter(destinationInfo -> this.stompMessageOperations.getDestinationMatch().get(destinationInfo.getDestination()).matcher(destination).matches()).forEach(destinationInfo -> {
            WebSocket sendSocket = this.stompMessageOperations.getWebSocketMap().get(destinationInfo.getSessionId());
            if (sendSocket == null) {
                return;
            }
            this.send(sendSocket, this.transform("MESSAGE", destinationInfo.getDestination(), payload, contentType, Arrays.asList(new Header("subscription", destinationInfo.getSubscription()), new Header("message-id", UUID.randomUUID().toString()))));
        });
    }

    public Message transform(String command, String destination, String payload) {
        return this.transform(command, destination, payload, null, null);
    }

    public Message transform(String command, String destination, String payload, String contentType) {
        return this.transform(command, destination, payload, contentType, null);
    }

    public Message transform(String command, String destination, String payload, List<Header> headers) {
        return this.transform(command, destination, payload, null, headers);
    }

    public Message transform(String command, String destination, String payload, String contentType, List<Header> headers) {
        MessageImpl replyMessage = new MessageImpl(command, payload);
        if (contentType != null && contentType.length() > 0) {
            replyMessage.addHeader("content-type", contentType);
        }
        replyMessage.addHeader("destination", destination);
        if (headers != null && headers.size() > 0) {
            replyMessage.getHeaderAll().addAll(headers);
        }
        return replyMessage;
    }
}

