/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.http;

import java.net.URL;
import org.noear.solon.Utils;
import org.noear.solon.net.http.HttpException;
import org.noear.solon.net.http.HttpResponse;

public class HttpResponseException
extends HttpException {
    private final int statusCode;
    private final String statusMessage;
    private byte[] bodyBytes;
    private final String requestMethod;
    private final URL requestUrl;

    public int code() {
        return this.statusCode;
    }

    public String message() {
        return this.statusMessage;
    }

    public byte[] bodyBytes() {
        return this.bodyBytes;
    }

    public String requestMethod() {
        return this.requestMethod;
    }

    public URL requestUrl() {
        return this.requestUrl;
    }

    public HttpResponseException(HttpResponse response, String requestMethod, URL requestUrl) {
        super(HttpResponseException.buildMessage(response, requestMethod, requestUrl));
        this.statusCode = response.code();
        this.statusMessage = response.message();
        this.requestMethod = requestMethod;
        this.requestUrl = requestUrl;
        try {
            this.bodyBytes = response.bodyAsBytes();
        }
        catch (Throwable ex) {
            this.bodyBytes = new byte[0];
        }
    }

    public HttpResponseException(HttpResponse response, String requestMethod, URL requestUrl, Throwable cause) {
        super(HttpResponseException.buildMessage(response, requestMethod, requestUrl), cause);
        this.statusCode = response.code();
        this.statusMessage = response.message();
        this.requestMethod = requestMethod;
        this.requestUrl = requestUrl;
        try {
            this.bodyBytes = response.bodyAsBytes();
        }
        catch (Throwable ex) {
            this.bodyBytes = new byte[0];
        }
    }

    private static String buildMessage(HttpResponse response, String requestMethod, URL requestUrl) {
        StringBuilder buf = new StringBuilder();
        buf.append(response.code());
        buf.append(" ");
        if (Utils.isNotEmpty((String)response.message())) {
            buf.append(response.message());
        }
        buf.append(" from ").append(requestMethod).append(" ");
        buf.append(requestUrl.getProtocol()).append("://").append(requestUrl.getHost());
        if (requestUrl.getPort() > 0) {
            buf.append(":").append(requestUrl.getPort());
        }
        buf.append(requestUrl.getPath());
        return buf.toString();
    }
}

