/*
 * Copyright 2017-2025 noear.org and authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.noear.solon.net.http;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;

/**
 * Http Ssl 提供者
 *
 * @author noear
 * @since 3.4
 */
public interface HttpSslSupplier {
    /**
     * 获取证书上下文
     */
    SSLContext getSslContext();

    /**
     * 获取证书套接字工厂
     */
    default SSLSocketFactory getSocketFactory() {
        return getSslContext().getSocketFactory();
    }

    /**
     * 获取域名的核对机
     */
    HostnameVerifier getHostnameVerifier();

    /**
     * 获取信任管理器
     */
    X509TrustManager getX509TrustManager();
}