/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.http.impl.jdk;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.HttpsURLConnection;
import org.noear.solon.Utils;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.IoUtil;
import org.noear.solon.core.util.KeyValues;
import org.noear.solon.core.util.MultiMap;
import org.noear.solon.net.http.HttpResponse;
import org.noear.solon.net.http.HttpUtils;
import org.noear.solon.net.http.impl.AbstractHttpUtils;
import org.noear.solon.net.http.impl.HttpSslSupplierDefault;
import org.noear.solon.net.http.impl.HttpUploadFile;
import org.noear.solon.net.http.impl.jdk.JdkHttpDispatcherLoader;
import org.noear.solon.net.http.impl.jdk.JdkHttpResponse;

public class JdkHttpUtils
extends AbstractHttpUtils
implements HttpUtils {
    static final Set<String> METHODS_NOBODY = new HashSet<String>(3);
    protected static final JdkHttpDispatcherLoader dispatcherLoader;

    public JdkHttpUtils(String url) {
        super(url);
    }

    @Override
    protected HttpResponse execDo(String _method, CompletableFuture<HttpResponse> future) throws IOException {
        String method = _method.toUpperCase();
        String newUrl = this.urlRebuild(method, this._url, this._charset);
        HttpURLConnection _client = this.getClient(newUrl);
        if (this._headers != null) {
            for (KeyValues kv : this._headers) {
                for (String val : kv.getValues()) {
                    _client.addRequestProperty(kv.getKey(), val);
                }
            }
        }
        if (this._cookies != null) {
            _client.setRequestProperty("Cookie", this.getRequestCookieString((MultiMap<String>)this._cookies));
        }
        _client.setRequestMethod(method);
        _client.setUseCaches(false);
        _client.setDoInput(true);
        if (future == null) {
            return this.request(_client, method);
        }
        dispatcherLoader.getDispatcher().submit(() -> {
            try {
                HttpResponse resp = this.request(_client, method);
                future.complete(resp);
            }
            catch (IOException | RuntimeException e) {
                future.completeExceptionally(e);
            }
        });
        return null;
    }

    protected HttpURLConnection getClient(String newUrl) throws IOException {
        HttpURLConnection _builder;
        if (this._sslSupplier == null) {
            this._sslSupplier = HttpSslSupplierDefault.getInstance();
        }
        if ((_builder = this.openConnection(newUrl)) instanceof HttpsURLConnection) {
            HttpsURLConnection tmp = (HttpsURLConnection)_builder;
            tmp.setSSLSocketFactory(this._sslSupplier.getSocketFactory());
            tmp.setHostnameVerifier(this._sslSupplier.getHostnameVerifier());
        }
        if (this._timeout != null) {
            if (this._timeout.getConnectTimeout() != null) {
                _builder.setConnectTimeout((int)this._timeout.getConnectTimeout().toMillis());
            }
            if (this._timeout.getReadTimeout() != null) {
                _builder.setReadTimeout((int)this._timeout.getReadTimeout().toMillis());
            }
        }
        return _builder;
    }

    protected HttpURLConnection openConnection(String newUrl) throws IOException {
        if (this._proxy == null) {
            return (HttpURLConnection)new URL(newUrl).openConnection();
        }
        return (HttpURLConnection)new URL(newUrl).openConnection(this._proxy);
    }

    protected HttpResponse request(HttpURLConnection _builder, String method) throws IOException {
        try {
            block32: {
                if (!METHODS_NOBODY.contains(method)) {
                    if (this._bodyRaw != null) {
                        if (this._bodyRaw.getContentType() != null) {
                            _builder.setRequestProperty("Content-Type", this._bodyRaw.getContentType());
                        }
                        _builder.setDoOutput(true);
                        try (OutputStream out = _builder.getOutputStream();
                             InputStream ins = this._bodyRaw.getContent();){
                            IoUtil.transferTo((InputStream)ins, (OutputStream)out);
                            break block32;
                        }
                    }
                    if (this._multipart) {
                        _builder.setDoOutput(true);
                        new FormDataBody(this._charset).write(_builder, (MultiMap<HttpUploadFile>)this._files, (MultiMap<String>)this._params);
                    } else if (!Utils.isEmpty((MultiMap)this._params)) {
                        _builder.setDoOutput(true);
                        new FormBody(this._charset).write(_builder, (MultiMap<String>)this._params);
                    }
                }
            }
            return this.getResponse(_builder, method);
        }
        catch (IOException | RuntimeException e) {
            _builder.disconnect();
            throw e;
        }
    }

    protected HttpResponse getResponse(HttpURLConnection _builder, String method) throws IOException {
        int statusCode = _builder.getResponseCode();
        if (JdkHttpUtils.isRedirected(statusCode)) {
            String location = _builder.getHeaderField("Location");
            if (Utils.isEmpty((String)location)) {
                throw new IOException("Redirect location header unfound, original url: " + this._url);
            }
            this._url = JdkHttpUtils.getLocationUrl(this._url, location);
            return this.execDo(method, null);
        }
        return new JdkHttpResponse(this, statusCode, _builder);
    }

    protected String urlRebuild(String method, String url, Charset charset) throws UnsupportedEncodingException {
        String query0;
        String hostAndPath0;
        String query;
        int pathOf = url.indexOf("://");
        int queryOf = url.indexOf("?");
        String schema = url.substring(0, pathOf + 3);
        String hostAndPath = queryOf > 0 ? url.substring(pathOf + 3, queryOf) : url.substring(pathOf + 3);
        String string = query = queryOf > 0 ? url.substring(queryOf) : "";
        if (hostAndPath.length() > 0 && hostAndPath.equals(hostAndPath0 = URLDecoder.decode(hostAndPath, charset.name()))) {
            hostAndPath = HttpUtils.urlEncode(hostAndPath, charset.name());
            hostAndPath = hostAndPath.replace("%2F", "/").replace("%3A", ":");
        }
        if (query.length() > 0 && query.equals(query0 = URLDecoder.decode(query, charset.name()))) {
            query = HttpUtils.urlEncode(query, charset.name());
            query = query.replace("%3F", "?").replace("%2F", "/").replace("%3A", ":").replace("%3D", "=").replace("%26", "&").replace("%40", "@").replace("%23", "#");
        }
        StringBuilder newUrl = new StringBuilder();
        newUrl.append(schema);
        newUrl.append(hostAndPath);
        newUrl.append(query);
        if (this._params != null && "GET".equals(method)) {
            for (KeyValues kv : this._params) {
                String key = HttpUtils.urlEncode(kv.getKey(), charset.name());
                for (String val : kv.getValues()) {
                    if (newUrl.indexOf("?") < 0) {
                        newUrl.append("?");
                    } else {
                        newUrl.append("&");
                    }
                    newUrl.append(key).append("=").append(HttpUtils.urlEncode(val, charset.name()));
                }
            }
            this._params.clear();
        }
        return newUrl.toString();
    }

    public static void allowPatch() {
        JdkHttpUtils.allowMethods("PATCH");
    }

    public static void allowMethods(String ... methods) {
        try {
            Field methodsField = HttpURLConnection.class.getDeclaredField("methods");
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            ClassUtil.accessibleAsTrue((AccessibleObject)modifiersField);
            modifiersField.setInt(methodsField, methodsField.getModifiers() & 0xFFFFFFEF);
            ClassUtil.accessibleAsTrue((AccessibleObject)methodsField);
            String[] oldMethods = (String[])methodsField.get(null);
            LinkedHashSet<String> methodsSet = new LinkedHashSet<String>(Arrays.asList(oldMethods));
            methodsSet.addAll(Arrays.asList(methods));
            String[] newMethods = methodsSet.toArray(new String[0]);
            methodsField.set(null, newMethods);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
    }

    static {
        METHODS_NOBODY.add("HEAD");
        METHODS_NOBODY.add("TRACE");
        METHODS_NOBODY.add("OPTIONS");
        dispatcherLoader = new JdkHttpDispatcherLoader();
    }

    public static class FormBody {
        private final String contentType;
        private final Charset charset;

        FormBody(Charset charset) {
            this.charset = charset;
            this.contentType = "application/x-www-form-urlencoded";
        }

        void write(HttpURLConnection http, MultiMap<String> paramMap) throws IOException {
            http.setRequestProperty("Content-Type", this.contentType);
            try (OutputStream out = http.getOutputStream();){
                StringBuilder builder = new StringBuilder(128);
                for (KeyValues kv : paramMap) {
                    for (Object val : kv.getValues()) {
                        builder.append(HttpUtils.urlEncode(kv.getKey(), this.charset.name()));
                        builder.append("=");
                        builder.append(HttpUtils.urlEncode(String.valueOf(val), this.charset.name()));
                        builder.append("&");
                    }
                }
                String data = builder.delete(builder.length() - 1, builder.length()).toString();
                out.write(data.getBytes(this.charset));
                out.flush();
            }
        }
    }

    public static class FormDataBody {
        private static final String CRLF = "\r\n";
        private static final String fileFormat = "Content-Disposition: form-data; name=\"%s\"; filename=\"%s\"";
        private static final String textFormat = "Content-Disposition: form-data; name=\"%s\"";
        private final Charset charset;
        private final String contentType;
        private final String boundary = Long.toHexString(System.currentTimeMillis());

        public FormDataBody(Charset charset) {
            this.contentType = "multipart/form-data; boundary=" + this.boundary;
            this.charset = charset;
        }

        void write(HttpURLConnection http, MultiMap<HttpUploadFile> fileMap, MultiMap<String> paramMap) throws IOException {
            http.setRequestProperty("Content-Type", this.contentType);
            try (OutputStream out = http.getOutputStream();
                 PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(out, this.charset), true);){
                if (fileMap != null) {
                    for (KeyValues kv : fileMap) {
                        for (Object val : kv.getValues()) {
                            this.appendPartFile(out, writer, kv.getKey(), (HttpUploadFile)val);
                        }
                    }
                }
                if (paramMap != null) {
                    for (KeyValues kv : paramMap) {
                        for (Object val : kv.getValues()) {
                            this.appendPartText(out, writer, kv.getKey(), (String)val);
                        }
                    }
                }
                writer.append("--").append(this.boundary).append("--").append(CRLF).flush();
            }
        }

        private void appendPartFile(OutputStream out, PrintWriter writer, String key, HttpUploadFile value) throws IOException {
            writer.append("--").append(this.boundary).append(CRLF);
            writer.append(String.format(fileFormat, HttpUtils.urlEncode(key, this.charset.name()), value.fileName)).append(CRLF);
            if (value.fileStream.getContentType() != null) {
                writer.append("Content-Type: ").append(value.fileStream.getContentType()).append(CRLF);
            }
            writer.append("Content-Transfer-Encoding: binary").append(CRLF);
            writer.append(CRLF).flush();
            try (InputStream ins = value.fileStream.getContent();){
                IoUtil.transferTo((InputStream)ins, (OutputStream)out);
            }
            writer.append(CRLF).flush();
        }

        private void appendPartText(OutputStream out, PrintWriter writer, String key, String value) throws IOException {
            writer.append("--").append(this.boundary).append(CRLF);
            writer.append(String.format(textFormat, HttpUtils.urlEncode(key, this.charset.name()))).append(CRLF);
            writer.append(CRLF).flush();
            writer.append(value).flush();
            writer.append(CRLF).flush();
        }
    }
}

