/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.http.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.Proxy;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.serialize.Serializer;
import org.noear.solon.core.util.KeyValues;
import org.noear.solon.core.util.MultiMap;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.exception.SolonException;
import org.noear.solon.net.http.HttpConfiguration;
import org.noear.solon.net.http.HttpException;
import org.noear.solon.net.http.HttpExtension;
import org.noear.solon.net.http.HttpResponse;
import org.noear.solon.net.http.HttpSslSupplier;
import org.noear.solon.net.http.HttpTimeout;
import org.noear.solon.net.http.HttpUtils;
import org.noear.solon.net.http.impl.HttpStream;
import org.noear.solon.net.http.impl.HttpUploadFile;
import org.noear.solon.net.http.textstream.ServerSentEvent;
import org.noear.solon.net.http.textstream.TextStreamUtil;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpUtils
implements HttpUtils {
    static final Logger log = LoggerFactory.getLogger(AbstractHttpUtils.class);
    protected boolean _enablePrintln = false;
    protected Proxy _proxy = null;
    protected HttpSslSupplier _sslSupplier = null;
    protected String _url;
    protected Charset _charset = StandardCharsets.UTF_8;
    protected MultiMap<String> _headers;
    protected MultiMap<String> _cookies;
    protected MultiMap<String> _params;
    protected MultiMap<HttpUploadFile> _files;
    protected HttpStream _bodyRaw;
    protected boolean _multipart = false;
    protected HttpTimeout _timeout;
    protected Serializer _serializer;

    public AbstractHttpUtils(String url) {
        this._url = url;
        this._timeout = HttpTimeout.of(10, 60, 60);
        if (!url.contains("://")) {
            throw new IllegalArgumentException("No url scheme 'http' or 'https' found: " + url);
        }
        this.initExtension();
    }

    @Override
    public HttpUtils serializer(Serializer serializer) {
        if (serializer != null) {
            if (serializer.mimeType() == null) {
                throw new IllegalArgumentException("Invalid Serializer mimeType: " + serializer.getClass().getName());
            }
            if (serializer.dataType() == null) {
                throw new IllegalArgumentException("Invalid Serializer dataType: " + serializer.getClass().getName());
            }
            this._serializer = serializer;
        }
        return this;
    }

    @Override
    public Serializer serializer() {
        if (this._serializer == null) {
            if (Solon.app() != null) {
                this._serializer = Solon.app().serializerManager().get("@json");
            }
            if (this._serializer == null) {
                throw new SolonException("Missing serializer!");
            }
        }
        return this._serializer;
    }

    private void initExtension() {
        for (HttpExtension ext : HttpConfiguration.getExtensions()) {
            ext.onInit(this, this._url);
        }
    }

    @Override
    public HttpUtils enablePrintln(boolean enable) {
        this._enablePrintln = enable;
        return this;
    }

    @Override
    public HttpUtils proxy(Proxy proxy) {
        this._proxy = proxy;
        return this;
    }

    @Override
    public HttpUtils ssl(HttpSslSupplier sslProvider) {
        this._sslSupplier = sslProvider;
        return this;
    }

    @Override
    public HttpUtils timeout(HttpTimeout timeout) {
        if (timeout != null) {
            this._timeout = timeout;
        }
        return this;
    }

    @Override
    public HttpUtils multipart(boolean multipart) {
        this._multipart = multipart;
        return this;
    }

    @Override
    public HttpUtils userAgent(String ua) {
        this.header("User-Agent", ua);
        return this;
    }

    @Override
    public HttpUtils charset(String charset) {
        this._charset = Charset.forName(charset);
        return this;
    }

    public Charset charset() {
        return this._charset;
    }

    @Override
    public HttpUtils headers(Map headers) {
        if (headers != null) {
            this.tryInitHeaders();
            headers.forEach((k, v) -> {
                if (k != null && v != null) {
                    this._headers.put(k.toString(), (Object)v.toString());
                }
            });
        }
        return this;
    }

    @Override
    public HttpUtils headers(Iterable<KeyValues<String>> headers) {
        if (headers != null) {
            this.tryInitHeaders();
            for (KeyValues<String> kv : headers) {
                this._headers.holder(kv.getKey()).setValues(kv.getValues());
            }
        }
        return this;
    }

    @Override
    public HttpUtils header(String name, String value) {
        if (name == null || value == null) {
            return this;
        }
        this.tryInitHeaders().put(name, (Object)value);
        return this;
    }

    @Override
    public HttpUtils headerAdd(String name, String value) {
        if (name == null || value == null) {
            return this;
        }
        this.tryInitHeaders().add(name, (Object)value);
        return this;
    }

    @Override
    public HttpUtils cookies(Map cookies) {
        if (cookies != null) {
            this.tryInitCookies();
            cookies.forEach((k, v) -> {
                if (k != null && v != null) {
                    this._cookies.put(k.toString(), (Object)v.toString());
                }
            });
        }
        return this;
    }

    @Override
    public HttpUtils cookies(Iterable<KeyValues<String>> cookies) {
        if (cookies != null) {
            this.tryInitCookies();
            for (KeyValues<String> kv : cookies) {
                this._cookies.holder(kv.getKey()).setValues(kv.getValues());
            }
        }
        return this;
    }

    @Override
    public HttpUtils cookie(String name, String value) {
        if (name == null || value == null) {
            return this;
        }
        this.tryInitCookies().put(name, (Object)value);
        return this;
    }

    @Override
    public HttpUtils cookieAdd(String name, String value) {
        if (name == null || value == null) {
            return this;
        }
        this.tryInitCookies().add(name, (Object)value);
        return this;
    }

    @Override
    public HttpUtils data(Map data) {
        if (data != null) {
            this.tryInitParams();
            data.forEach((k, v) -> {
                if (k != null && v != null) {
                    this._params.put(k.toString(), (Object)v.toString());
                }
            });
        }
        return this;
    }

    @Override
    public HttpUtils data(Iterable<KeyValues<String>> data) {
        if (data != null) {
            this.tryInitParams();
            for (KeyValues<String> kv : data) {
                this._params.holder(kv.getKey()).setValues(kv.getValues());
            }
        }
        return this;
    }

    @Override
    public HttpUtils data(String name, String value) {
        if (name == null || value == null) {
            return this;
        }
        this.tryInitParams().add(name, (Object)value);
        return this;
    }

    @Override
    public HttpUtils data(String name, String filename, InputStream inputStream, String contentType) {
        if (name == null || inputStream == null) {
            return this;
        }
        this.multipart(true);
        this.tryInitFiles().add(name, (Object)new HttpUploadFile(filename, new HttpStream(inputStream, contentType)));
        return this;
    }

    @Override
    public HttpUtils data(String name, String filename, File file) {
        if (name == null || file == null) {
            return this;
        }
        if (filename == null) {
            filename = file.getName();
        }
        this.multipart(true);
        this.tryInitFiles().add(name, (Object)new HttpUploadFile(filename, new HttpStream(filename, file)));
        return this;
    }

    @Override
    public HttpUtils body(String txt, String contentType) {
        if (txt != null) {
            this.body(txt.getBytes(this._charset), contentType);
        }
        return this;
    }

    @Override
    public HttpUtils bodyOfBean(Object obj) throws HttpException {
        Object tmp;
        try {
            tmp = this.serializer().serialize(obj);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        if (tmp instanceof String) {
            this.body((String)tmp, this.serializer().mimeType());
        } else if (tmp instanceof byte[]) {
            this.body((byte[])tmp, this.serializer().mimeType());
        } else {
            throw new IllegalArgumentException("Invalid serializer type!");
        }
        return this;
    }

    @Override
    public HttpUtils body(byte[] bytes, String contentType) {
        if (bytes == null) {
            return this;
        }
        return this.body(new ByteArrayInputStream(bytes), contentType);
    }

    @Override
    public HttpUtils body(InputStream raw, String contentType) {
        if (raw != null) {
            this._bodyRaw = new HttpStream(raw, contentType);
        }
        return this;
    }

    @Override
    public String get() throws HttpException {
        return this.execAsBody("GET");
    }

    @Override
    public <T> T getAs(Type type) throws HttpException {
        return this.execAsBody("GET", type);
    }

    @Override
    public String post() throws HttpException {
        return this.execAsBody("POST");
    }

    @Override
    public <T> T postAs(Type type) throws HttpException {
        return this.execAsBody("POST", type);
    }

    @Override
    public String put() throws HttpException {
        return this.execAsBody("PUT");
    }

    @Override
    public <T> T putAs(Type type) throws HttpException {
        return this.execAsBody("PUT", type);
    }

    @Override
    public String patch() throws HttpException {
        return this.execAsBody("PATCH");
    }

    @Override
    public <T> T patchAs(Type type) throws HttpException {
        return this.execAsBody("PATCH", type);
    }

    @Override
    public String delete() throws HttpException {
        return this.execAsBody("DELETE");
    }

    @Override
    public <T> T deleteAs(Type type) throws HttpException {
        return this.execAsBody("DELETE", type);
    }

    @Override
    public String options() throws HttpException {
        return this.execAsBody("OPTIONS");
    }

    @Override
    public int head() throws HttpException {
        return this.execAsCode("HEAD");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String execAsBody(String method) throws HttpException {
        try (HttpResponse resp = this.exec(method);){
            String text = resp.bodyAsString();
            if (this._enablePrintln) {
                System.out.println(method + " " + this._url + ":: " + text);
            }
            String string = text;
            return string;
        }
        catch (HttpException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SolonException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T execAsBody(String method, Type type) throws HttpException {
        try (HttpResponse resp = this.exec(method);){
            Object t = resp.bodyAsBean(type);
            return t;
        }
        catch (HttpException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SolonException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int execAsCode(String method) throws HttpException {
        try (HttpResponse resp = this.exec(method);){
            int code = resp.code();
            if (this._enablePrintln) {
                System.out.println(method + " " + this._url + "::code:: " + code);
            }
            int n = code;
            return n;
        }
        catch (HttpException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SolonException((Throwable)e);
        }
    }

    @Override
    public Publisher<String> execAsLineStream(String method) {
        return subscriber -> this.execAsync(method).whenComplete((resp, err) -> {
            block6: {
                if (err == null) {
                    try {
                        if (resp.code() < 400) {
                            TextStreamUtil.parseLineStream(resp, (Subscriber<? super String>)subscriber);
                            break block6;
                        }
                        String message = (String)RunUtil.callAndTry(resp::bodyAsString);
                        if (Utils.isEmpty((String)message)) {
                            subscriber.onError((Throwable)((Object)new HttpException("Error code: " + resp.code())));
                            break block6;
                        }
                        subscriber.onError((Throwable)((Object)new HttpException("Error code: " + resp.code() + ", message: " + message)));
                    }
                    catch (Exception e) {
                        subscriber.onError((Throwable)e);
                    }
                } else {
                    subscriber.onError(err);
                }
            }
        });
    }

    @Override
    public Publisher<ServerSentEvent> execAsSseStream(String method) {
        this.header("Accept", "text/event-stream");
        this.header("Cache-Control", "no-cache");
        return subscriber -> this.execAsync(method).whenComplete((resp, err) -> {
            block6: {
                if (err == null) {
                    try {
                        if (resp.code() < 400) {
                            TextStreamUtil.parseSseStream(resp, (Subscriber<? super ServerSentEvent>)subscriber);
                            break block6;
                        }
                        String message = (String)RunUtil.callAndTry(resp::bodyAsString);
                        if (Utils.isEmpty((String)message)) {
                            subscriber.onError((Throwable)((Object)new HttpException("Error code: " + resp.code())));
                            break block6;
                        }
                        subscriber.onError((Throwable)((Object)new HttpException("Error code: " + resp.code() + ", message: " + message)));
                    }
                    catch (Exception e) {
                        subscriber.onError((Throwable)e);
                    }
                } else {
                    subscriber.onError(err);
                }
            }
        });
    }

    @Override
    public HttpResponse exec(String method) throws HttpException {
        try {
            return this.execDo(method, null);
        }
        catch (Exception e) {
            throw new HttpException(method + " " + this._url + ", request failed", e);
        }
    }

    @Override
    public CompletableFuture<HttpResponse> execAsync(String method) {
        CompletableFuture<HttpResponse> future = new CompletableFuture<HttpResponse>();
        try {
            this.execDo(method, future);
        }
        catch (Exception e) {
            future.completeExceptionally((Throwable)((Object)new HttpException(method + " " + this._url + ", request failed", e)));
        }
        return future;
    }

    protected abstract HttpResponse execDo(String var1, CompletableFuture<HttpResponse> var2) throws IOException;

    protected String getRequestCookieString(MultiMap<String> cookies) {
        StringBuilder sb = new StringBuilder();
        for (KeyValues kv : cookies) {
            for (String val : kv.getValues()) {
                sb.append(kv.getKey()).append('=').append(val).append("; ");
            }
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 2);
        }
        return sb.toString();
    }

    protected MultiMap<String> tryInitParams() {
        if (this._params == null) {
            this._params = new MultiMap();
        }
        return this._params;
    }

    protected MultiMap<HttpUploadFile> tryInitFiles() {
        if (this._files == null) {
            this._files = new MultiMap();
        }
        return this._files;
    }

    protected MultiMap<String> tryInitCookies() {
        if (this._cookies == null) {
            this._cookies = new MultiMap();
        }
        return this._cookies;
    }

    protected MultiMap<String> tryInitHeaders() {
        if (this._headers == null) {
            this._headers = new MultiMap();
        }
        return this._headers;
    }

    protected static boolean isRedirected(int responseCode) {
        return responseCode == 301 || responseCode == 302 || responseCode == 303 || responseCode == 307 || responseCode == 308;
    }

    public static String getLocationUrl(String refererUrl, String location) {
        String redirectUrl;
        if (!location.contains("://")) {
            URI refererUri = URI.create(refererUrl);
            if (!location.startsWith("/")) {
                String refererPath = refererUri.getPath();
                if (!refererPath.endsWith("/")) {
                    int tmp = refererPath.lastIndexOf(47);
                    refererPath = refererPath.substring(0, tmp + 1);
                }
                location = refererPath + location;
            }
            redirectUrl = refererUri.getScheme() + "://" + refererUri.getAuthority() + location;
        } else {
            redirectUrl = location;
        }
        return redirectUrl;
    }
}

