/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.http.impl.okhttp;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.Response;
import org.noear.solon.core.util.MultiMap;
import org.noear.solon.exception.SolonException;
import org.noear.solon.net.http.HttpResponse;
import org.noear.solon.net.http.impl.okhttp.OkHttpUtils;

public class OkHttpResponse
implements HttpResponse {
    private final OkHttpUtils utils;
    private final Response response;
    private MultiMap<String> cookies;
    private final int statusCode;

    public OkHttpResponse(OkHttpUtils utils, int statusCode, Response response) {
        this.utils = utils;
        this.response = response;
        this.statusCode = statusCode;
    }

    private MultiMap<String> cookiesInit() {
        if (this.cookies == null) {
            this.cookies = new MultiMap();
            List<String> kvAry = this.headers("Set-Cookie");
            for (String kvStr : kvAry) {
                int eqIdx = kvStr.indexOf("=");
                int smIdx = kvStr.indexOf(";", eqIdx);
                String key = kvStr.substring(0, eqIdx);
                String value = smIdx > 0 ? kvStr.substring(eqIdx + 1, smIdx) : kvStr.substring(eqIdx + 1);
                this.cookies.add(key, (Object)value);
            }
        }
        return this.cookies;
    }

    @Override
    public Collection<String> headerNames() {
        return this.response.headers().names();
    }

    @Override
    public String header(String name) {
        return this.response.header(name);
    }

    @Override
    public List<String> headers(String name) {
        return this.response.headers(name);
    }

    @Override
    public Collection<String> cookieNames() {
        return this.cookiesInit().keySet();
    }

    @Override
    public String cookie(String name) {
        return (String)this.cookiesInit().get(name);
    }

    @Override
    public List<String> cookies(String name) {
        return this.cookiesInit().getAll(name);
    }

    @Override
    public Long contentLength() {
        return this.response.body().contentLength();
    }

    @Override
    public String contentType() {
        MediaType tmp = this.response.body().contentType();
        if (tmp == null) {
            return null;
        }
        return tmp.type();
    }

    @Override
    public Charset contentEncoding() {
        MediaType tmp = this.response.body().contentType();
        if (tmp == null) {
            return null;
        }
        return tmp.charset();
    }

    @Override
    public List<String> cookies() {
        return this.response.headers("Set-Cookie");
    }

    @Override
    public int code() {
        return this.statusCode;
    }

    @Override
    public InputStream body() {
        return this.response.body().byteStream();
    }

    @Override
    public byte[] bodyAsBytes() throws IOException {
        return this.response.body().bytes();
    }

    @Override
    public String bodyAsString() throws IOException {
        return this.response.body().string();
    }

    @Override
    public <T> T bodyAsBean(Type type) throws IOException {
        if (String.class == this.utils.serializer().dataType()) {
            return (T)this.utils.serializer().deserialize((Object)this.bodyAsString(), type);
        }
        if (byte[].class == this.utils.serializer().dataType()) {
            return (T)this.utils.serializer().deserialize((Object)this.bodyAsBytes(), type);
        }
        throw new SolonException("Invalid serializer type!");
    }

    @Override
    public void close() throws IOException {
        this.response.close();
    }
}

