/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.http.impl.okhttp;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.noear.solon.Utils;
import org.noear.solon.core.util.KeyValues;
import org.noear.solon.core.util.MultiMap;
import org.noear.solon.net.http.HttpResponse;
import org.noear.solon.net.http.HttpTimeout;
import org.noear.solon.net.http.HttpUtils;
import org.noear.solon.net.http.impl.AbstractHttpUtils;
import org.noear.solon.net.http.impl.HttpStream;
import org.noear.solon.net.http.impl.HttpUploadFile;
import org.noear.solon.net.http.impl.okhttp.OkHttpResponse;
import org.noear.solon.net.http.impl.okhttp.OkHttpUtilsFactory;

public class OkHttpUtils
extends AbstractHttpUtils
implements HttpUtils {
    private final OkHttpUtilsFactory factory;

    public OkHttpUtils(OkHttpUtilsFactory factory, String url) {
        super(url);
        this.factory = factory;
    }

    @Override
    protected HttpResponse execDo(String _method, final CompletableFuture<HttpResponse> future) throws IOException {
        final String method = _method.toUpperCase();
        String newUrl = this.urlRebuild(method, this._url, this._charset);
        Request.Builder _builder = new Request.Builder().url(newUrl);
        if (this._timeout != null) {
            _builder.tag(HttpTimeout.class, (Object)this._timeout);
        }
        if (this._headers != null) {
            this._headers.forEach(kv -> {
                for (String val : kv.getValues()) {
                    _builder.addHeader(kv.getKey(), val);
                }
            });
        }
        if (this._cookies != null) {
            _builder.header("Cookie", this.getRequestCookieString((MultiMap<String>)this._cookies));
        }
        StreamBody _body = null;
        if (this._bodyRaw != null) {
            _body = new StreamBody(this._bodyRaw);
        } else if (this._multipart) {
            MultipartBody.Builder _part_builer = new MultipartBody.Builder().setType(MultipartBody.FORM);
            if (!Utils.isEmpty((MultiMap)this._files)) {
                for (KeyValues kv2 : this._files) {
                    for (Object val : kv2.getValues()) {
                        _part_builer.addFormDataPart(kv2.getKey(), ((HttpUploadFile)val).fileName, (RequestBody)new StreamBody(((HttpUploadFile)val).fileStream));
                    }
                }
            }
            if (!Utils.isEmpty((MultiMap)this._params)) {
                for (KeyValues kv2 : this._params) {
                    for (Object val : kv2.getValues()) {
                        _part_builer.addFormDataPart(kv2.getKey(), (String)val);
                    }
                }
            }
            try {
                _body = _part_builer.build();
            }
            catch (IllegalStateException illegalStateException) {}
        } else if (!Utils.isEmpty((MultiMap)this._params)) {
            String _form_builer = new FormBody.Builder(this._charset);
            for (KeyValues kv2 : this._params) {
                for (String val : kv2.getValues()) {
                    _form_builer.add(kv2.getKey(), val);
                }
            }
            _body = _form_builer.build();
        }
        if (_body == null) {
            _body = new FormBody.Builder(this._charset).build();
        }
        switch (method.toUpperCase()) {
            case "POST": {
                _builder.method("POST", (RequestBody)_body);
                break;
            }
            case "PUT": {
                _builder.method("PUT", (RequestBody)_body);
                break;
            }
            case "DELETE": {
                _builder.method("DELETE", (RequestBody)_body);
                break;
            }
            case "PATCH": {
                _builder.method("PATCH", (RequestBody)_body);
                break;
            }
            case "GET": {
                _builder.method("GET", null);
                break;
            }
            case "HEAD": {
                _builder.method("HEAD", null);
                break;
            }
            case "OPTIONS": {
                _builder.method("OPTIONS", null);
                break;
            }
            case "TRACE": {
                _builder.method("TRACE", null);
                break;
            }
            default: {
                throw new IllegalArgumentException("This method is not supported");
            }
        }
        OkHttpUtils self = this;
        OkHttpClient _client = this.factory.getClient(this._proxy);
        if (future == null) {
            Call call = _client.newCall(_builder.build());
            return this.getResponse(call.execute(), method);
        }
        _client.newCall(_builder.build()).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                future.completeExceptionally(e);
                call.cancel();
            }

            public void onResponse(Call call, Response response) throws IOException {
                future.complete(OkHttpUtils.this.getResponse(response, method));
            }
        });
        return null;
    }

    protected HttpResponse getResponse(Response response, String method) throws IOException {
        int statusCode = response.code();
        if (OkHttpUtils.isRedirected(statusCode)) {
            String location = response.header("Location");
            if (Utils.isEmpty((String)location)) {
                throw new IOException("Redirect location header unfound, original url: " + this._url);
            }
            this._url = location;
            return this.execDo(method, null);
        }
        return new OkHttpResponse(this, statusCode, response);
    }

    protected String urlRebuild(String method, String url, Charset charset) throws UnsupportedEncodingException {
        if (this._params != null && "GET".equals(method)) {
            StringBuilder newUrl = new StringBuilder(url);
            for (KeyValues kv : this._params) {
                String key = HttpUtils.urlEncode(kv.getKey(), charset.name());
                for (String val : kv.getValues()) {
                    if (newUrl.indexOf("?") < 0) {
                        newUrl.append("?");
                    } else {
                        newUrl.append("&");
                    }
                    newUrl.append(key).append("=").append(HttpUtils.urlEncode(val, charset.name()));
                }
            }
            this._params.clear();
            return newUrl.toString();
        }
        return url;
    }

    public static class StreamBody
    extends RequestBody {
        private MediaType _contentType = null;
        private HttpStream _httpStream = null;

        public StreamBody(HttpStream stream) {
            if (stream.getContentType() != null) {
                this._contentType = MediaType.parse((String)stream.getContentType());
            }
            this._httpStream = stream;
        }

        public MediaType contentType() {
            return this._contentType;
        }

        public long contentLength() throws IOException {
            return this._httpStream.getContentLength();
        }

        public void writeTo(BufferedSink sink) throws IOException {
            Source source = null;
            try {
                source = Okio.source((InputStream)this._httpStream.getContent());
                sink.writeAll(source);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(source);
                throw throwable;
            }
            Util.closeQuietly((Closeable)source);
        }
    }
}

