/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.maven.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.noear.solon.loader.JarLauncher;

public class CopyLoader {
    static String path;
    static String name;
    static String tempName;

    public static void start(File file) throws Exception {
        name = file.getName();
        tempName = UUID.randomUUID() + ".jar";
        path = file.getAbsolutePath().replace(name, "");
        if (CopyLoader.setLoader()) {
            CopyLoader.organizeFiles();
        }
    }

    private static void organizeFiles() throws IOException {
        FileUtils.delete((File)new File(path + name));
        FileUtils.moveFile((File)new File(path + tempName), (File)new File(path + name));
    }

    private static boolean setLoader() throws IOException {
        try {
            ProtectionDomain protectionDomain = JarLauncher.class.getProtectionDomain();
            CodeSource codeSource = protectionDomain.getCodeSource();
            URI location = codeSource == null ? null : codeSource.getLocation().toURI();
            String mavenPluginJarPath = location == null ? null : location.getSchemeSpecificPart();
            JarFile jarfile = new JarFile(mavenPluginJarPath);
            JarFile targetJarfile = new JarFile(path + name);
            JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(path + tempName));
            Enumeration<JarEntry> entries = jarfile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (jarEntry.isDirectory() || !jarEntry.getName().contains("org/noear/solon/loader/") || !jarEntry.getName().endsWith(".class")) continue;
                jarOutputStream.putNextEntry(jarEntry);
                byte[] bytes = IOUtils.toByteArray((InputStream)jarfile.getInputStream(jarEntry));
                jarOutputStream.write(bytes);
            }
            Enumeration<JarEntry> targetEntries = targetJarfile.entries();
            while (targetEntries.hasMoreElements()) {
                JarEntry entry = targetEntries.nextElement();
                InputStream entryInputStream = targetJarfile.getInputStream(entry);
                jarOutputStream.putNextEntry(entry);
                jarOutputStream.write(IOUtils.toByteArray((InputStream)entryInputStream));
            }
            jarOutputStream.flush();
            jarOutputStream.close();
            targetJarfile.close();
            jarfile.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

