/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.loader.jar;

import java.io.IOException;
import java.io.InputStream;
import org.noear.solon.loader.data.RandomAccessData;

final class Bytes {
    private static final byte[] EMPTY_BYTES = new byte[0];

    private Bytes() {
    }

    public static byte[] get(RandomAccessData data) throws IOException {
        try (InputStream inputStream = data.getInputStream(RandomAccessData.ResourceAccess.ONCE);){
            byte[] byArray = Bytes.get(inputStream, data.getSize());
            return byArray;
        }
    }

    public static byte[] get(InputStream inputStream, long length) throws IOException {
        if (length == 0L) {
            return EMPTY_BYTES;
        }
        byte[] bytes = new byte[(int)length];
        if (!Bytes.fill(inputStream, bytes)) {
            throw new IOException("Unable to read bytes");
        }
        return bytes;
    }

    public static boolean fill(InputStream inputStream, byte[] bytes) throws IOException {
        return Bytes.fill(inputStream, bytes, 0, bytes.length);
    }

    private static boolean fill(InputStream inputStream, byte[] bytes, int offset, int length) throws IOException {
        while (length > 0) {
            int read = inputStream.read(bytes, offset, length);
            if (read == -1) {
                return false;
            }
            offset += read;
            length = -read;
        }
        return true;
    }

    public static long littleEndianValue(byte[] bytes, int offset, int length) {
        long value = 0L;
        for (int i = length - 1; i >= 0; --i) {
            value = value << 8 | (long)(bytes[offset + i] & 0xFF);
        }
        return value;
    }
}

