/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.loader;

import java.lang.reflect.Method;

public class MainMethodRunner
implements Runnable {
    private final String mainClassName;
    private final String[] args;

    public MainMethodRunner(String mainClass, String[] args) {
        this.mainClassName = mainClass;
        this.args = args == null ? null : (String[])args.clone();
    }

    @Override
    public void run() {
        try {
            Class<?> mainClass = Thread.currentThread().getContextClassLoader().loadClass(this.mainClassName);
            Method mainMethod = mainClass.getDeclaredMethod("main", String[].class);
            if (mainMethod == null) {
                throw new IllegalStateException(this.mainClassName + " does not have a main method");
            }
            mainMethod.setAccessible(true);
            mainMethod.invoke(null, new Object[]{this.args});
        }
        catch (Exception ex) {
            System.exit(1);
        }
    }
}

