/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.maven.plugin.tools.tool;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.noear.solon.maven.plugin.tools.tool.Layout;
import org.noear.solon.maven.plugin.tools.tool.LibraryScope;
import org.noear.solon.maven.plugin.tools.tool.RepackagingLayout;

public final class Layouts {
    private Layouts() {
    }

    public static Layout forFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null");
        }
        if (file.getName().toLowerCase(Locale.ENGLISH).endsWith(".jar")) {
            return new Jar();
        }
        throw new IllegalStateException("Unable to deduce layout for '" + file + "'");
    }

    @Deprecated
    public static class Module
    implements Layout {
        private static final Set<LibraryScope> LIB_DESTINATION_SCOPES = new HashSet<LibraryScope>(Arrays.asList(LibraryScope.COMPILE, LibraryScope.RUNTIME, LibraryScope.CUSTOM));

        @Override
        public String getLibraryDestination(String libraryName, LibraryScope scope) {
            if (LIB_DESTINATION_SCOPES.contains(scope)) {
                return "lib/";
            }
            return null;
        }
    }

    public static class Jar
    implements RepackagingLayout {
        @Override
        public String getLibraryDestination(String libraryName, LibraryScope scope) {
            return "lib/";
        }

        @Override
        public String getRepackagedClassesLocation() {
            return "";
        }
    }
}

