/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.luffy.impl;

import java.util.concurrent.CompletableFuture;
import org.noear.luffy.dso.JtBridge;
import org.noear.luffy.executor.ExecutorFactory;
import org.noear.luffy.executor.IJtConfigAdapter;
import org.noear.luffy.executor.IJtExecutorAdapter;
import org.noear.luffy.model.AFileModel;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextEmpty;
import org.noear.solon.luffy.impl.JtExecutorAdapter;
import org.noear.solon.luffy.impl.JtFunctionLoader;
import org.noear.solon.luffy.impl.JtFunctionLoaderClasspath;
import org.noear.solon.luffy.impl.JtFunctionLoaderManager;

public class JtRun {
    private static CompletableFuture<Integer> initFuture = new CompletableFuture();
    private static final JtFunctionLoaderManager resourceLoader = new JtFunctionLoaderManager();
    private static JtExecutorAdapter jtAdapter;

    public static void init() {
        if (jtAdapter == null) {
            resourceLoader.add(0, new JtFunctionLoaderClasspath());
            Solon.context().subBeansOfType(JtFunctionLoader.class, bean -> resourceLoader.add(0, (JtFunctionLoader)bean));
            jtAdapter = new JtExecutorAdapter(resourceLoader);
            JtBridge.executorAdapterSet((IJtExecutorAdapter)jtAdapter);
            JtBridge.configAdapterSet((IJtConfigAdapter)jtAdapter);
        }
    }

    public static JtFunctionLoaderManager getResourceLoader() {
        return resourceLoader;
    }

    public static AFileModel fileGet(String path) throws Exception {
        return jtAdapter.fileGet(path);
    }

    public static void dele(String path) throws Exception {
        String name = path.replace("/", "__");
        ExecutorFactory.del((String)name);
    }

    public static Object call(String path) throws Exception {
        return JtRun.call(path, ContextEmpty.create());
    }

    public static Object call(String path, Context ctx) throws Exception {
        AFileModel file = JtBridge.fileGet((String)path);
        return ExecutorFactory.execOnly((AFileModel)file, (Context)ctx);
    }

    public static void exec(String path) throws Exception {
        JtRun.exec(path, ContextEmpty.create());
    }

    public static void exec(String path, Context ctx) throws Exception {
        AFileModel file = JtBridge.fileGet((String)path);
        ExecutorFactory.execOnly((AFileModel)file, (Context)ctx);
    }

    public static void execCode(String code) throws Exception {
        AFileModel file = new AFileModel();
        file.path = Utils.md5((String)code);
        file.content = code;
        file.edit_mode = "javascript";
        JtRun.execFile(file);
    }

    public static void execFile(AFileModel file) throws Exception {
        initFuture.get();
        Context ctx = Context.current();
        if (ctx == null) {
            ctx = ContextEmpty.create();
            Context.currentWith((Context)ctx, () -> {
                ExecutorFactory.execOnly((AFileModel)file, (Context)Context.current());
                return null;
            });
        } else {
            ExecutorFactory.execOnly((AFileModel)file, (Context)ctx);
        }
    }

    public static void xfunInit() {
        try {
            Thread.sleep(500L);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        initFuture.complete(1);
    }
}

