/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.luffy.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.noear.luffy.model.AFileModel;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.util.IoUtil;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.luffy.impl.JtFunctionLoader;
import org.noear.solon.luffy.impl.JtModelUtils;

public class JtFunctionLoaderClasspath
implements JtFunctionLoader {
    private final Map<String, AFileModel> fileCached = new LinkedHashMap<String, AFileModel>();
    private final ReentrantLock SYNC_LOCK = new ReentrantLock();

    @Override
    public AFileModel fileGet(String path) throws Exception {
        AFileModel file = this.fileCached.get(path);
        if (file == null) {
            this.SYNC_LOCK.lock();
            try {
                file = this.fileCached.get(path);
                if (file == null) {
                    file = this.fileGet0(path);
                    this.fileCached.put(path, file);
                }
            }
            finally {
                this.SYNC_LOCK.unlock();
            }
        }
        return file;
    }

    protected AFileModel fileGet0(String path) throws Exception {
        AFileModel fileModel = new AFileModel();
        fileModel.content = this.fileContentGet(path);
        if (Utils.isNotEmpty((String)fileModel.content)) {
            JtModelUtils.buildFileModel(fileModel, path);
        }
        return fileModel;
    }

    protected String fileContentGet(String path) throws IOException {
        URL url = ResourceUtil.getResource((String)("luffy/" + path));
        if (url == null) {
            return null;
        }
        File file = new File(url.getFile());
        if (file.exists() && file.isFile()) {
            try (InputStream in = url.openStream();){
                String string = IoUtil.transferToString((InputStream)in, (String)Solon.encoding());
                return string;
            }
        }
        return null;
    }
}

