/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.expression.snel;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.solon.expression.exception.EvaluationException;
import org.noear.solon.expression.snel.PropertyHolder;

public class ReflectionUtil {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPER_MAP = new HashMap();
    private static ReflectionUtil instance;
    private final Map<MethodKey, Method> cache = new ConcurrentHashMap<MethodKey, Method>();
    private final Map<Class<?>, Method[]> methodsCache = new ConcurrentHashMap();
    private final Map<String, PropertyHolder> PROPERTY_CACHE = new ConcurrentHashMap<String, PropertyHolder>();

    public static ReflectionUtil getInstance() {
        return instance;
    }

    private Method[] getMethods(Class<?> clazz) {
        return this.methodsCache.computeIfAbsent(clazz, Class::getMethods);
    }

    public Method getMethod(Class<?> clazz, String methodName, Class<?>[] argTypes) {
        MethodKey key = new MethodKey(clazz, methodName, argTypes);
        return this.cache.computeIfAbsent(key, k -> this.findMethod(clazz, methodName, argTypes));
    }

    private Method findMethod(Class<?> clazz, String methodName, Class<?>[] argTypes) {
        Method method = Arrays.stream(this.getMethods(clazz)).filter(m -> m.getName().equals(methodName)).filter(m -> this.isMethodMatch((Method)m, argTypes)).findFirst().orElse(null);
        if (method != null) {
            this.accessibleAsTrue(method);
        }
        return method;
    }

    private boolean isMethodMatch(Method method, Class<?>[] argTypes) {
        Class<?>[] paramTypes = method.getParameterTypes();
        if (method.isVarArgs()) {
            return this.isVarArgsMatch(method, paramTypes, argTypes);
        }
        if (paramTypes.length != argTypes.length) {
            return false;
        }
        for (int i = 0; i < paramTypes.length; ++i) {
            if (this.isAssignable(paramTypes[i], argTypes[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isVarArgsMatch(Method method, Class<?>[] paramTypes, Class<?>[] argTypes) {
        int i;
        if (paramTypes.length == 0) {
            return false;
        }
        Class<?> varArgType = paramTypes[paramTypes.length - 1];
        if (!varArgType.isArray()) {
            return false;
        }
        Class<?> varArgComponentType = varArgType.getComponentType();
        if (argTypes.length < paramTypes.length - 1) {
            return false;
        }
        for (i = 0; i < paramTypes.length - 1; ++i) {
            if (i >= argTypes.length || this.isAssignable(paramTypes[i], argTypes[i])) continue;
            return false;
        }
        for (i = paramTypes.length - 1; i < argTypes.length; ++i) {
            if (this.isAssignable(varArgComponentType, argTypes[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isAssignable(Class<?> targetType, Class<?> sourceType) {
        if (targetType.isPrimitive()) {
            Class<?> wrapperType = PRIMITIVE_WRAPPER_MAP.get(targetType);
            return wrapperType != null && wrapperType.isAssignableFrom(sourceType);
        }
        if (sourceType.isPrimitive()) {
            Class<?> targetWrapper = PRIMITIVE_WRAPPER_MAP.get(sourceType);
            return targetType.isAssignableFrom(targetWrapper);
        }
        if (targetType.isAssignableFrom(sourceType)) {
            return true;
        }
        return sourceType == Void.class;
    }

    public Object[] prepareInvokeArgs(Method method, Object[] argValues) {
        if (!method.isVarArgs()) {
            return argValues;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        int fixedParamCount = paramTypes.length - 1;
        Object[] invokeArgs = new Object[paramTypes.length];
        for (int i = 0; i < fixedParamCount; ++i) {
            invokeArgs[i] = i < argValues.length ? argValues[i] : null;
        }
        Class<?> varArgType = paramTypes[fixedParamCount];
        Class<?> varArgComponentType = varArgType.getComponentType();
        int varArgCount = Math.max(0, argValues.length - fixedParamCount);
        Object varArgsArray = Array.newInstance(varArgComponentType, varArgCount);
        for (int i = 0; i < varArgCount; ++i) {
            Array.set(varArgsArray, i, argValues[fixedParamCount + i]);
        }
        invokeArgs[fixedParamCount] = varArgsArray;
        return invokeArgs;
    }

    public PropertyHolder getProperty(Class<?> clazz, String propName) {
        String key = clazz.getName() + ":" + propName;
        return this.PROPERTY_CACHE.computeIfAbsent(key, k -> {
            try {
                String name = "get" + this.capitalize(propName);
                Method method = clazz.getMethod(name, new Class[0]);
                this.accessibleAsTrue(method);
                return new PropertyHolder(method, null);
            }
            catch (NoSuchMethodException e) {
                try {
                    Field field = clazz.getField(propName);
                    this.accessibleAsTrue(field);
                    return new PropertyHolder(null, field);
                }
                catch (NoSuchFieldException ex) {
                    throw new EvaluationException("Missing property: " + propName, e);
                }
            }
        });
    }

    private String capitalize(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    private void accessibleAsTrue(AccessibleObject method) {
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        PRIMITIVE_WRAPPER_MAP.put(Byte.TYPE, Byte.class);
        PRIMITIVE_WRAPPER_MAP.put(Short.TYPE, Short.class);
        PRIMITIVE_WRAPPER_MAP.put(Integer.TYPE, Integer.class);
        PRIMITIVE_WRAPPER_MAP.put(Long.TYPE, Long.class);
        PRIMITIVE_WRAPPER_MAP.put(Float.TYPE, Float.class);
        PRIMITIVE_WRAPPER_MAP.put(Double.TYPE, Double.class);
        PRIMITIVE_WRAPPER_MAP.put(Boolean.TYPE, Boolean.class);
        instance = new ReflectionUtil();
    }

    private static class MethodKey {
        private final Class<?> clazz;
        private final String methodName;
        private final Class<?>[] argTypes;

        public MethodKey(Class<?> clazz, String methodName, Class<?>[] argTypes) {
            this.clazz = clazz;
            this.methodName = methodName;
            this.argTypes = argTypes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodKey methodKey = (MethodKey)o;
            return this.clazz.equals(methodKey.clazz) && this.methodName.equals(methodKey.methodName) && Arrays.equals(this.argTypes, methodKey.argTypes);
        }

        public int hashCode() {
            int result = this.clazz.hashCode();
            result = 31 * result + this.methodName.hashCode();
            result = 31 * result + Arrays.hashCode(this.argTypes);
            return result;
        }
    }
}

