/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.expression.snel;

import java.util.function.Function;
import org.noear.solon.expression.Expression;
import org.noear.solon.expression.exception.EvaluationException;
import org.noear.solon.expression.snel.ArithmeticOp;

public class ArithmeticNode
implements Expression {
    private final ArithmeticOp operator;
    private final Expression left;
    private final Expression right;

    public ArithmeticNode(ArithmeticOp operator, Expression left, Expression right) {
        this.operator = operator;
        this.left = left;
        this.right = right;
    }

    public Object eval(Function context) {
        Object leftVal = this.left.eval(context);
        Object rightVal = this.right.eval(context);
        if (this.operator == ArithmeticOp.ADD && (leftVal instanceof String || rightVal instanceof String)) {
            return String.valueOf(leftVal) + rightVal;
        }
        if (leftVal == null) {
            throw new EvaluationException("Arithmetic left value is null");
        }
        if (rightVal == null) {
            throw new EvaluationException("Arithmetic right value is null");
        }
        return this.calculateNumbers((Number)leftVal, (Number)rightVal);
    }

    private Number calculateNumbers(Number a, Number b) {
        if (this.isDouble(a) || this.isDouble(b)) {
            return this.calculateAsDouble(a, b);
        }
        if (this.isFloat(a) || this.isFloat(b)) {
            return Float.valueOf(this.calculateAsFloat(a, b));
        }
        if (this.isLong(a) || this.isLong(b)) {
            return this.calculateAsLong(a, b);
        }
        return this.calculateAsInt(a, b);
    }

    private boolean isDouble(Number n) {
        return n instanceof Double;
    }

    private boolean isFloat(Number n) {
        return n instanceof Float;
    }

    private boolean isLong(Number n) {
        return n instanceof Long;
    }

    private double calculateAsDouble(Number a, Number b) {
        double aVal = a.doubleValue();
        double bVal = b.doubleValue();
        switch (this.operator) {
            case ADD: {
                return aVal + bVal;
            }
            case SUB: {
                return aVal - bVal;
            }
            case MUL: {
                return aVal * bVal;
            }
            case DIV: {
                return aVal / bVal;
            }
            case MOD: {
                return aVal % bVal;
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)this.operator));
    }

    private float calculateAsFloat(Number a, Number b) {
        float aVal = a.floatValue();
        float bVal = b.floatValue();
        switch (this.operator) {
            case ADD: {
                return aVal + bVal;
            }
            case SUB: {
                return aVal - bVal;
            }
            case MUL: {
                return aVal * bVal;
            }
            case DIV: {
                return aVal / bVal;
            }
            case MOD: {
                return aVal % bVal;
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)this.operator));
    }

    private long calculateAsLong(Number a, Number b) {
        long aVal = a.longValue();
        long bVal = b.longValue();
        switch (this.operator) {
            case ADD: {
                return aVal + bVal;
            }
            case SUB: {
                return aVal - bVal;
            }
            case MUL: {
                return aVal * bVal;
            }
            case DIV: {
                return aVal / bVal;
            }
            case MOD: {
                return aVal % bVal;
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)this.operator));
    }

    private int calculateAsInt(Number a, Number b) {
        int aVal = a.intValue();
        int bVal = b.intValue();
        switch (this.operator) {
            case ADD: {
                return aVal + bVal;
            }
            case SUB: {
                return aVal - bVal;
            }
            case MUL: {
                return aVal * bVal;
            }
            case DIV: {
                return aVal / bVal;
            }
            case MOD: {
                return aVal % bVal;
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)this.operator));
    }

    public String toString() {
        return "(" + this.left + " " + this.operator.getCode() + " " + this.right + ")";
    }
}

