/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.docs.openapi3;

import io.swagger.v3.oas.models.OpenAPI;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.docs.DocDocket;
import org.noear.solon.docs.models.ApiGroupResource;
import org.noear.solon.docs.openapi3.JacksonSerializer;
import org.noear.solon.docs.openapi3.OpenApi3Builder;
import org.noear.solon.docs.util.BasicAuthUtil;

public class OpenApi3Utils {
    public static String getApiGroupResourceJson() throws IOException {
        return JacksonSerializer.getInstance().serialize(OpenApi3Utils.getApiGroupResourceJson("/swagger/v3"));
    }

    public static String getSwaggerConfigJson() throws IOException {
        List<ApiGroupResource> apiGroupResourceJson = OpenApi3Utils.getApiGroupResourceJson("/swagger/v3");
        HashMap<String, List<ApiGroupResource>> stringObjectHashMap = new HashMap<String, List<ApiGroupResource>>();
        stringObjectHashMap.put("urls", apiGroupResourceJson);
        return JacksonSerializer.getInstance().serialize(stringObjectHashMap);
    }

    public static List<ApiGroupResource> getApiGroupResourceJson(String resourceUri) throws IOException {
        List list = Objects.requireNonNull(Solon.context()).getWrapsOfType(DocDocket.class);
        return list.stream().filter(bw -> Utils.isNotEmpty((String)bw.name())).map(bw -> {
            DocDocket docDocket = (DocDocket)bw.raw();
            if (docDocket.isEnable()) {
                String group = bw.name();
                String groupName = docDocket.groupName();
                String url = resourceUri + "?group=" + group;
                if (docDocket.upstream() == null) {
                    return new ApiGroupResource(groupName, docDocket.version(), url, "");
                }
                return new ApiGroupResource(groupName, docDocket.version(), url, docDocket.upstream().getContextPath());
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static String getApiJson(Context ctx, String group) throws IOException {
        DocDocket docket = (DocDocket)Solon.context().getBean(group);
        if (docket == null) {
            return null;
        }
        if (!BasicAuthUtil.basicAuth((Context)ctx, (DocDocket)docket)) {
            BasicAuthUtil.response401((Context)ctx);
            return null;
        }
        if (!docket.globalResponseCodes().containsKey(200)) {
            docket.globalResponseCodes().put(200, "");
        }
        OpenAPI openAPI = new OpenApi3Builder(docket).build();
        if (docket.serializer() == null) {
            return JacksonSerializer.getInstance().serialize(openAPI);
        }
        return (String)docket.serializer().serialize((Object)openAPI);
    }

    public static String getSwaggerJson(DocDocket docket) throws IOException {
        OpenAPI openAPI = new OpenApi3Builder(docket).build();
        if (docket.serializer() == null) {
            return JacksonSerializer.getInstance().serialize(openAPI);
        }
        return (String)docket.serializer().serialize((Object)openAPI);
    }
}

