/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.docs.openapi2;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Type;
import org.noear.solon.core.serialize.Serializer;
import org.noear.solon.core.util.ClassUtil;

public class JacksonSerializer
implements Serializer<String> {
    private static final JacksonSerializer instance = new JacksonSerializer();
    private ObjectMapper mapper = new ObjectMapper();

    public static JacksonSerializer getInstance() {
        return instance;
    }

    public JacksonSerializer() {
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public String name() {
        return "JacksonSerializer";
    }

    public String serialize(Object fromObj) throws IOException {
        return this.mapper.writeValueAsString(fromObj);
    }

    public Object deserialize(String data, Type toType) throws IOException {
        if (toType == null) {
            return this.mapper.readTree(data);
        }
        Class clz = ClassUtil.getTypeClass((Type)toType);
        return this.mapper.readValue(data, clz);
    }
}

