/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.datasource;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.noear.solon.Utils;
import org.noear.solon.core.Props;
import org.noear.solon.core.PropsConverter;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.lang.Nullable;

public class DsUtils {
    private static final String[] DEFAULT_CLASS_PROP_NAMES = new String[]{"type", "dataSourceClassName"};

    private static Class<?> resolveTypeOrNull(Properties props, String[] classPropNames) {
        String typeStr = Utils.propertyOr((Properties)props, (String[])classPropNames);
        if (Utils.isNotEmpty((String)typeStr)) {
            Utils.propertyRemove((Properties)props, (String[])classPropNames);
            Class typeClz = ClassUtil.loadClass((String)typeStr);
            if (typeClz == null || !DataSource.class.isAssignableFrom(typeClz)) {
                throw new IllegalStateException("Type configuration not is data source");
            }
            return typeClz;
        }
        return null;
    }

    private static Class<?> resolveTypeOrDefault(Properties props, Class<?> typeDef, String[] classPropNames) {
        String typeStr = Utils.propertyOr((Properties)props, (String[])classPropNames);
        Class typeClz = null;
        if (Utils.isEmpty((String)typeStr)) {
            typeClz = typeDef;
        } else {
            Utils.propertyRemove((Properties)props, (String[])classPropNames);
            typeClz = ClassUtil.loadClass((String)typeStr);
        }
        if (typeClz == null || !DataSource.class.isAssignableFrom(typeClz)) {
            throw new IllegalStateException("Type configuration not is data source");
        }
        return typeClz;
    }

    public static DataSource buildDs(Properties props) {
        return DsUtils.buildDs(props, DEFAULT_CLASS_PROP_NAMES);
    }

    public static DataSource buildDs(Properties props, String[] classPropNames) {
        Class<?> typeClz = DsUtils.resolveTypeOrDefault(props, null, classPropNames);
        return DsUtils.buildDs(props, typeClz);
    }

    public static DataSource buildDs(Properties props, Class<?> typeClz) {
        return (DataSource)PropsConverter.global().convert(props, typeClz);
    }

    public static Map<String, DataSource> buildDsMap(Properties props) {
        return DsUtils.buildDsMap(props, DEFAULT_CLASS_PROP_NAMES);
    }

    public static Map<String, DataSource> buildDsMap(Properties props, Class<?> typeDef) {
        return DsUtils.buildDsMap(props, typeDef, DEFAULT_CLASS_PROP_NAMES);
    }

    public static Map<String, DataSource> buildDsMap(Properties props, String[] classPropNames) {
        Class<?> typeClz = DsUtils.resolveTypeOrNull(props, classPropNames);
        return DsUtils.buildDsMap(props, typeClz, classPropNames);
    }

    public static Map<String, DataSource> buildDsMap(Properties props, @Nullable Class<?> typeDef, String[] classPropNames) {
        Props rootProps;
        if (props instanceof Props) {
            rootProps = (Props)props;
        } else {
            rootProps = new Props();
            rootProps.putAll((Map)props);
        }
        Map groupProps = rootProps.getGroupedProp("");
        if (groupProps.size() == 0) {
            throw new IllegalStateException("Missing data source configuration");
        }
        LinkedHashMap<String, DataSource> dataSourceMap = new LinkedHashMap<String, DataSource>();
        for (Map.Entry kv : groupProps.entrySet()) {
            if (((Props)kv.getValue()).size() <= 1) continue;
            Class<?> typeClz = DsUtils.resolveTypeOrDefault((Properties)kv.getValue(), typeDef, classPropNames);
            DataSource source = DsUtils.buildDs((Properties)kv.getValue(), typeClz);
            dataSourceMap.put((String)kv.getKey(), source);
        }
        return dataSourceMap;
    }
}

