/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sql.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import javax.sql.DataSource;
import org.noear.solon.Solon;
import org.noear.solon.data.sql.SqlExecutor;
import org.noear.solon.data.sql.SqlUtils;
import org.noear.solon.data.sql.impl.CommandHolder;
import org.noear.solon.data.sql.impl.SimpleSqlExecutor;
import org.noear.solon.data.tran.TranUtils;

public class SimpleSqlUtils
implements SqlUtils {
    private final DataSource dataSource;

    public SimpleSqlUtils(DataSource dataSource) {
        assert (dataSource != null);
        this.dataSource = dataSource;
    }

    protected Connection getConnection() throws SQLException {
        if (Solon.app() == null) {
            return this.dataSource.getConnection();
        }
        return TranUtils.getConnectionProxy((DataSource)this.dataSource);
    }

    protected Object getObject(CommandHolder holder, int columnIdx) throws SQLException {
        return holder.rsts.getObject(columnIdx);
    }

    protected void setObject(PreparedStatement stmt, int columnIdx, Object val) throws SQLException {
        if (val == null) {
            stmt.setNull(columnIdx, 12);
        } else if (val instanceof Date) {
            if (val instanceof java.sql.Date) {
                stmt.setDate(columnIdx, (java.sql.Date)val);
            } else if (val instanceof Timestamp) {
                stmt.setTimestamp(columnIdx, (Timestamp)val);
            } else {
                Date v1 = (Date)val;
                stmt.setTimestamp(columnIdx, new Timestamp(v1.getTime()));
            }
        } else {
            stmt.setObject(columnIdx, val);
        }
    }

    protected CommandHolder buildCommand(String sql, Object args, boolean returnKeys, boolean isStream) throws SQLException {
        CommandHolder holder = new CommandHolder(this);
        holder.conn = this.getConnection();
        holder.stmt = isStream ? (sql.startsWith("{call") ? holder.conn.prepareCall(sql, 1003, 1007) : holder.conn.prepareStatement(sql, 1003, 1007)) : (returnKeys ? holder.conn.prepareStatement(sql, 1) : (sql.startsWith("{call") ? holder.conn.prepareCall(sql) : holder.conn.prepareStatement(sql)));
        if (args instanceof Collection) {
            Collection argsList = (Collection)args;
            for (Object[] row : argsList) {
                for (int i = 0; i < row.length; ++i) {
                    this.setObject(holder.stmt, i + 1, row[i]);
                }
                holder.stmt.addBatch();
            }
        } else {
            Object[] row = (Object[])args;
            for (int i = 0; i < row.length; ++i) {
                this.setObject(holder.stmt, i + 1, row[i]);
            }
        }
        return holder;
    }

    @Override
    public SqlExecutor sql(String sql, Object ... args) {
        return new SimpleSqlExecutor(this, sql, args);
    }
}

