/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sql;

import java.util.ArrayList;
import java.util.List;
import org.noear.solon.Utils;

public class SqlBuilder {
    private StringBuilder c_builder = new StringBuilder(200);
    private List<Object> c_args = new ArrayList<Object>();
    private StringBuilder b_builder = new StringBuilder();
    private List<Object> b_args = new ArrayList<Object>();

    public int indexOf(String str) {
        return this.c_builder.indexOf(str);
    }

    public String substring(int start) {
        return this.c_builder.substring(start);
    }

    public String substring(int start, int end) {
        return this.c_builder.substring(start, end);
    }

    public int length() {
        return this.c_builder.length();
    }

    public void clear() {
        this.c_builder.delete(0, this.c_builder.length());
        this.c_args.clear();
    }

    public void backup() {
        this.b_builder.append((CharSequence)this.c_builder);
        this.b_args.addAll(this.c_args);
    }

    public void restore() {
        this.clear();
        this.c_builder.append((CharSequence)this.b_builder);
        this.c_args.addAll(this.b_args);
    }

    public SqlBuilder insert(int offset, String sql, Object ... args) {
        if (offset < 0) {
            this.append(sql, args);
        } else {
            SqlPartBuilder tmp = new SqlPartBuilder(sql, args);
            if (offset == 0) {
                this.c_builder.insert(0, tmp.sql);
                this.c_args.addAll(0, tmp.args);
            } else {
                String idxBef = this.c_builder.substring(0, offset);
                int idxBefQm = 0;
                for (int i = 0; i < idxBef.length(); ++i) {
                    if (idxBef.charAt(i) != '?') continue;
                    ++idxBefQm;
                }
                this.c_builder.insert(offset, tmp.sql);
                this.c_args.addAll(idxBefQm, tmp.args);
            }
        }
        return this;
    }

    public SqlBuilder insert(String sql, Object ... args) {
        return this.insert(0, sql, args);
    }

    public SqlBuilder insert(SqlBuilder part) {
        this.c_builder.insert(0, part.c_builder);
        this.c_args.addAll(0, part.c_args);
        return this;
    }

    public SqlBuilder appendIf(boolean condition, String sql, Object ... args) {
        if (condition) {
            if (Utils.isEmpty((Object[])args)) {
                this.c_builder.append(sql);
            } else {
                SqlPartBuilder pb = new SqlPartBuilder(sql, args);
                this.c_builder.append(pb.sql);
                this.c_args.addAll(pb.args);
            }
        }
        return this;
    }

    public SqlBuilder append(String sql, Object ... args) {
        return this.appendIf(true, sql, args);
    }

    public SqlBuilder append(SqlBuilder sqlPart) {
        this.c_builder.append((CharSequence)sqlPart.c_builder);
        this.c_args.addAll(sqlPart.c_args);
        return this;
    }

    public SqlBuilder remove(int start, int length) {
        this.c_builder.delete(start, start + length);
        return this;
    }

    public SqlBuilder removeLast() {
        this.c_builder.setLength(this.c_builder.length() - 1);
        return this;
    }

    public SqlBuilder trimEnd(String str) {
        int len = str.length();
        if (len > 0) {
            int idx;
            String tmp = this.c_builder.toString().trim();
            while ((idx = tmp.lastIndexOf(str)) == tmp.length() - len) {
                tmp = tmp.substring(0, tmp.length() - len);
            }
            this.c_builder.setLength(0);
            this.c_builder.append(tmp);
        }
        return this;
    }

    public SqlBuilder trimStart(String str) {
        int len = str.length();
        if (len > 0) {
            int idx;
            String tmp = this.c_builder.toString().trim();
            while ((idx = tmp.indexOf(str)) == 0) {
                tmp = tmp.substring(len);
            }
            this.c_builder.setLength(0);
            this.c_builder.append(tmp);
        }
        return this;
    }

    public String getSql() {
        return this.c_builder.toString();
    }

    public Object[] getArgs() {
        return this.c_args.toArray();
    }

    public String toString() {
        return this.c_builder.toString();
    }

    static class SqlPartBuilder {
        public CharSequence sql;
        public List<Object> args = new ArrayList<Object>();

        public SqlPartBuilder(CharSequence sql, Object[] args) {
            if (args != null && args.length > 0) {
                StringBuilder buf = new StringBuilder();
                buf.append(sql);
                for (Object a1 : args) {
                    if (a1 instanceof Iterable) {
                        StringBuilder sb = new StringBuilder();
                        for (Object a2 : (Iterable)a1) {
                            this.args.add(a2);
                            sb.append("?").append(",");
                        }
                        int len = sb.length();
                        if (len > 0) {
                            sb.deleteCharAt(len - 1);
                        }
                        int idx = buf.indexOf("?...");
                        String tmp = sb.toString();
                        if (len == 0) {
                            buf.replace(idx, idx + 4, "null");
                            continue;
                        }
                        buf.replace(idx, idx + 4, tmp);
                        continue;
                    }
                    this.args.add(a1);
                }
                this.sql = buf;
            } else {
                this.sql = sql;
            }
        }
    }
}

