/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core.visitor;

import io.github.kiryu1223.expressionTree.delegate.Func1;
import io.github.kiryu1223.expressionTree.expressions.Expression;
import io.github.kiryu1223.expressionTree.expressions.FieldSelectExpression;
import io.github.kiryu1223.expressionTree.expressions.Kind;
import io.github.kiryu1223.expressionTree.expressions.MethodCallExpression;
import io.github.kiryu1223.expressionTree.expressions.ParameterExpression;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.noear.solon.data.sqlink.api.crud.read.IDynamicColumn;
import org.noear.solon.data.sqlink.api.crud.read.group.IGroup;
import org.noear.solon.data.sqlink.base.expression.AsName;
import org.noear.solon.data.sqlink.base.metaData.FieldMetaData;
import org.noear.solon.data.sqlink.base.metaData.MetaData;
import org.noear.solon.data.sqlink.base.metaData.MetaDataCache;
import org.noear.solon.data.sqlink.base.sqlExt.SqlExtensionExpression;
import org.noear.solon.data.sqlink.base.sqlExt.SqlOperatorMethod;
import org.noear.solon.data.sqlink.core.exception.SqLinkException;

public class ExpressionUtil {
    public static boolean isDynamicColumn(Method method) {
        String name = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        return IDynamicColumn.class.isAssignableFrom(method.getDeclaringClass()) && name.equals("column") && parameterTypes.length == 1 && ExpressionUtil.isString(parameterTypes[0]);
    }

    public static boolean isEquals(MethodCallExpression methodCall) {
        Method method = methodCall.getMethod();
        if (method.getParameterCount() != 1) {
            return false;
        }
        if (method.getParameterTypes()[0] != Object.class) {
            return false;
        }
        if (method.getReturnType() != Boolean.TYPE) {
            return false;
        }
        return method.getName().equals("equals");
    }

    public static boolean isProperty(Map<ParameterExpression, AsName> asNameMap, MethodCallExpression methodCall) {
        if (methodCall.getExpr().getKind() != Kind.Parameter) {
            return false;
        }
        ParameterExpression parameter = (ParameterExpression)methodCall.getExpr();
        return asNameMap.containsKey(parameter);
    }

    public static boolean isProperty(Map<ParameterExpression, AsName> asNameMap, FieldSelectExpression fieldSelect) {
        if (fieldSelect.getExpr().getKind() != Kind.Parameter) {
            return false;
        }
        ParameterExpression parameter = (ParameterExpression)fieldSelect.getExpr();
        return asNameMap.containsKey(parameter);
    }

    public static boolean isGroupKey(Map<ParameterExpression, AsName> parameters, Expression expression) {
        if (expression.getKind() != Kind.FieldSelect) {
            return false;
        }
        FieldSelectExpression fieldSelect = (FieldSelectExpression)expression;
        if (fieldSelect.getExpr().getKind() != Kind.Parameter) {
            return false;
        }
        ParameterExpression parameter = (ParameterExpression)fieldSelect.getExpr();
        Field field = fieldSelect.getField();
        return parameters.containsKey(parameter) && IGroup.class.isAssignableFrom(field.getDeclaringClass()) && field.getName().equals("key");
    }

    public static boolean isGetter(Method method) {
        if (ExpressionUtil.isVoid(method.getReturnType())) {
            return false;
        }
        if (method.getParameterCount() != 0) {
            return false;
        }
        String name = method.getName();
        return name.startsWith("get") || name.startsWith("is");
    }

    public static boolean isSetter(Method method) {
        if (method.getParameterCount() != 1) {
            return false;
        }
        String name = method.getName();
        return name.startsWith("set");
    }

    public static boolean isSqlOperatorMethod(Method method) {
        return method.isAnnotationPresent(SqlOperatorMethod.class);
    }

    public static boolean isSqlExtensionExpressionMethod(Method method) {
        SqlExtensionExpression[] annotationsByType = (SqlExtensionExpression[])method.getAnnotationsByType(SqlExtensionExpression.class);
        return annotationsByType != null && annotationsByType.length > 0;
    }

    public static <R> R cast(Object o) {
        return (R)o;
    }

    public static Class<?> getTargetType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            Type dbType = pType.getActualTypeArguments()[0];
            return (Class)dbType;
        }
        throw new SqLinkException("\u65e0\u6cd5\u83b7\u53d6\u96c6\u5408\u7684\u76ee\u6807\u7c7b\u578b:" + type);
    }

    public static boolean isVoid(Class<?> c) {
        return c == Void.class || c == Void.TYPE;
    }

    public static boolean isBool(Class<?> type) {
        return type == Boolean.TYPE || type == Boolean.class;
    }

    public static boolean isChar(Class<?> type) {
        return type == Character.TYPE || type == Character.class;
    }

    public static boolean isString(Class<?> type) {
        return type == String.class;
    }

    public static boolean isInt(Class<?> type) {
        return type == Integer.TYPE || type == Integer.class;
    }

    public static boolean isLong(Class<?> type) {
        return type == Long.TYPE || type == Long.class;
    }

    public static boolean isByte(Class<?> type) {
        return type == Byte.TYPE || type == Byte.class;
    }

    public static boolean isDateTime(Class<?> type) {
        return type == java.util.Date.class || type == LocalDateTime.class || type == Timestamp.class;
    }

    public static boolean isTime(Class<?> type) {
        return type == Time.class || type == LocalTime.class;
    }

    public static boolean isDate(Class<?> type) {
        return type == Date.class || type == LocalDate.class;
    }

    public static boolean isShort(Class<?> type) {
        return type == Short.TYPE || type == Short.class;
    }

    public static boolean isFloat(Class<?> type) {
        return type == Float.TYPE || type == Float.class;
    }

    public static boolean isDouble(Class<?> type) {
        return type == Double.TYPE || type == Double.class;
    }

    public static boolean isDecimal(Class<?> type) {
        return type == BigDecimal.class;
    }

    public static Class<?> upperClass(Class<?> c) {
        if (c.isPrimitive()) {
            if (c == Character.TYPE) {
                return Character.class;
            }
            if (c == Byte.TYPE) {
                return Byte.class;
            }
            if (c == Short.TYPE) {
                return Short.class;
            }
            if (c == Integer.TYPE) {
                return Integer.class;
            }
            if (c == Long.TYPE) {
                return Long.class;
            }
            if (c == Float.TYPE) {
                return Float.class;
            }
            if (c == Double.TYPE) {
                return Double.class;
            }
            if (c == Boolean.TYPE) {
                return Boolean.class;
            }
            return Void.class;
        }
        return c;
    }

    public static String getFirst(Class<?> c) {
        MetaData metaData = MetaDataCache.getMetaData(c);
        return metaData.getTableName().substring(0, 1).toLowerCase();
    }

    public static AsName doGetAsName(String as, Set<String> asNames) {
        return ExpressionUtil.doGetAsName0(asNames, as, 0);
    }

    private static AsName doGetAsName0(Set<String> asNameSet, String as, int offset) {
        String next;
        String string = next = offset == 0 ? as : as + offset;
        if (asNameSet.contains(next)) {
            return ExpressionUtil.doGetAsName0(asNameSet, as, offset + 1);
        }
        return new AsName(next);
    }

    public static <T> List<T> buildTree(List<T> flatList, FieldMetaData child, FieldMetaData parent, FieldMetaData list, Func1<T, Collection<T>> func) {
        HashMap nodeMap = new HashMap();
        ArrayList<T> rootNodes = new ArrayList<T>();
        for (T node : flatList) {
            nodeMap.put(child.getValueByObject(node), node);
        }
        for (T node : flatList) {
            Object parentValue = parent.getValueByObject(node);
            Object parentNode = nodeMap.get(parentValue);
            if (parentNode == null) {
                rootNodes.add(node);
                continue;
            }
            ArrayList<T> collection = (ArrayList<T>)func.invoke(parentNode);
            if (collection == null) {
                collection = new ArrayList<T>();
                try {
                    list.getSetter().invoke(parentNode, collection);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            collection.add(node);
        }
        return rootNodes;
    }
}

