/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.api.crud.create;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.noear.solon.data.sqlink.annotation.GenerateStrategy;
import org.noear.solon.data.sqlink.annotation.InsertDefaultValue;
import org.noear.solon.data.sqlink.api.crud.CRUD;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.SqLinkDialect;
import org.noear.solon.data.sqlink.base.generate.DynamicGenerator;
import org.noear.solon.data.sqlink.base.metaData.FieldMetaData;
import org.noear.solon.data.sqlink.base.metaData.MetaData;
import org.noear.solon.data.sqlink.base.metaData.MetaDataCache;
import org.noear.solon.data.sqlink.base.session.SqlSession;
import org.noear.solon.data.sqlink.base.session.SqlValue;
import org.noear.solon.data.sqlink.base.toBean.handler.ITypeHandler;
import org.noear.solon.data.sqlink.core.exception.SqLinkException;
import org.noear.solon.data.sqlink.core.sqlBuilder.InsertSqlBuilder;
import org.noear.solon.data.sqlink.core.visitor.ExpressionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InsertBase
extends CRUD {
    public static final Logger log = LoggerFactory.getLogger(InsertBase.class);
    private final InsertSqlBuilder sqlBuilder;

    protected InsertSqlBuilder getSqlBuilder() {
        return this.sqlBuilder;
    }

    @Override
    protected SqLinkConfig getConfig() {
        return this.sqlBuilder.getConfig();
    }

    public InsertBase(SqLinkConfig c) {
        this.sqlBuilder = new InsertSqlBuilder(c);
    }

    public long executeRows() {
        List objects = this.getObjects();
        if (!objects.isEmpty()) {
            return this.objectsExecuteRows();
        }
        return 0L;
    }

    @Override
    public String toSql() {
        if (!this.getObjects().isEmpty()) {
            return this.makeByObjects(MetaDataCache.getMetaData(this.getTableType()).getNotIgnorePropertys(), null);
        }
        return this.sqlBuilder.getSql();
    }

    protected <T> List<T> getObjects() {
        return Collections.emptyList();
    }

    protected abstract <T> Class<T> getTableType();

    private long objectsExecuteRows() {
        MetaData metaData = MetaDataCache.getMetaData(this.getTableType());
        List<FieldMetaData> notIgnorePropertys = metaData.getNotIgnorePropertys();
        SqLinkConfig config = this.getConfig();
        ArrayList<SqlValue> sqlValues = new ArrayList<SqlValue>();
        String sql = this.makeByObjects(notIgnorePropertys, sqlValues);
        this.tryPrintSql(log, sql);
        SqlSession session = config.getSqlSessionFactory().getSession(config);
        if (this.getObjects().size() > 1) {
            this.tryPrintBatch(log, this.getObjects().size());
        } else {
            this.tryPrintNoBatch(log, this.getObjects().size());
        }
        return session.executeInsert(sql, sqlValues, notIgnorePropertys.size());
    }

    private String makeByObjects(List<FieldMetaData> notIgnorePropertys, List<SqlValue> sqlValues) {
        SqLinkDialect disambiguation = this.getConfig().getDisambiguation();
        MetaData metaData = MetaDataCache.getMetaData(this.getTableType());
        ArrayList<String> tableFields = new ArrayList<String>();
        ArrayList<String> tableValues = new ArrayList<String>();
        for (FieldMetaData fieldMetaData : notIgnorePropertys) {
            InsertDefaultValue insertDefaultValue = fieldMetaData.getInsertDefaultValue();
            if (insertDefaultValue != null && insertDefaultValue.strategy() == GenerateStrategy.DataBase) continue;
            tableFields.add(disambiguation.disambiguation(fieldMetaData.getColumn()));
            tableValues.add("?");
        }
        if (sqlValues != null) {
            for (FieldMetaData object : this.getObjects()) {
                for (FieldMetaData fieldMetaData : notIgnorePropertys) {
                    Object value = fieldMetaData.getValueByObject(object);
                    ITypeHandler<?> typeHandler = fieldMetaData.getTypeHandler();
                    InsertDefaultValue onInsert = fieldMetaData.getInsertDefaultValue();
                    if (onInsert != null) {
                        switch (onInsert.strategy()) {
                            case DataBase: {
                                break;
                            }
                            case Static: {
                                if (value == null) {
                                    value = typeHandler.castStringToTarget(onInsert.value(), fieldMetaData.getGenericType());
                                }
                                sqlValues.add(new SqlValue(value, typeHandler, fieldMetaData.getOnPut()));
                                break;
                            }
                            case Dynamic: {
                                if (value == null) {
                                    DynamicGenerator generator = DynamicGenerator.get((Class)ExpressionUtil.cast(onInsert.dynamic()));
                                    value = generator.generate(this.getConfig(), fieldMetaData);
                                }
                                sqlValues.add(new SqlValue(value, typeHandler, fieldMetaData.getOnPut()));
                            }
                        }
                        continue;
                    }
                    if (value == null && fieldMetaData.isNotNull()) {
                        throw new SqLinkException(String.format("%s\u7c7b\u7684%s\u5b57\u6bb5\u88ab\u8bbe\u7f6e\u4e3anotnull\uff0c\u4f46\u662f\u5b57\u6bb5\u503c\u4e3a\u7a7a\u4e14\u6ca1\u6709\u8bbe\u7f6e\u9ed8\u8ba4\u503c\u6ce8\u89e3", fieldMetaData.getParentType(), fieldMetaData.getProperty()));
                    }
                    sqlValues.add(new SqlValue(value, typeHandler, fieldMetaData.getOnPut()));
                }
            }
        }
        SqLinkDialect dialect = this.getSqlBuilder().getConfig().getDisambiguation();
        return "INSERT INTO " + dialect.disambiguationTableName(metaData.getTableName()) + "(" + String.join((CharSequence)",", tableFields) + ") VALUES(" + String.join((CharSequence)",", tableValues) + ")";
    }
}

