/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.base.expression.impl;

import java.util.List;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.SqLinkDialect;
import org.noear.solon.data.sqlink.base.expression.AsName;
import org.noear.solon.data.sqlink.base.expression.ISqlFromExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlQueryableExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlTableExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlWithExpression;
import org.noear.solon.data.sqlink.base.session.SqlValue;

public class SqlFromExpression
implements ISqlFromExpression {
    protected final ISqlTableExpression sqlTableExpression;
    protected AsName asName;

    public SqlFromExpression(ISqlTableExpression sqlTableExpression, AsName asName) {
        this.sqlTableExpression = sqlTableExpression;
        this.asName = asName;
    }

    @Override
    public ISqlTableExpression getSqlTableExpression() {
        return this.sqlTableExpression;
    }

    @Override
    public AsName getAsName() {
        return this.asName;
    }

    @Override
    public String getSqlAndValue(SqLinkConfig config, List<SqlValue> values) {
        if (this.isEmptyTable()) {
            return "";
        }
        SqLinkDialect disambiguation = config.getDisambiguation();
        StringBuilder builder = new StringBuilder();
        if (this.sqlTableExpression instanceof ISqlWithExpression) {
            ISqlWithExpression withExpression = (ISqlWithExpression)this.sqlTableExpression;
            builder.append(disambiguation.disambiguationTableName(withExpression.withTableName()));
        } else {
            builder.append(this.sqlTableExpression.getSqlAndValue(config, values));
        }
        if (this.sqlTableExpression instanceof ISqlQueryableExpression) {
            builder.insert(0, "(");
            builder.append(")");
        }
        if (this.asName != null) {
            return "FROM " + builder + " AS " + disambiguation.disambiguation(this.asName.getName());
        }
        return "FROM " + builder;
    }
}

