/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.base;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DbType {
    Any,
    MySQL,
    SQLServer,
    H2,
    Oracle,
    SQLite,
    PostgreSQL;

    private static final Logger log;

    public static DbType getByName(String dbName) {
        switch (dbName) {
            case "MySQL": {
                return MySQL;
            }
            case "Microsoft SQL Server": {
                return SQLServer;
            }
            case "H2": {
                return H2;
            }
            case "Oracle": {
                return Oracle;
            }
            case "SQLite": {
                return SQLite;
            }
            case "PostgreSQL": {
                return PostgreSQL;
            }
        }
        log.warn("Unsupported database type:{}", (Object)dbName);
        return Any;
    }

    static {
        log = LoggerFactory.getLogger(DbType.class);
    }
}

