/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core;

import org.noear.solon.data.sqlink.api.Filter;
import org.noear.solon.data.sqlink.base.DbType;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.SqLinkDialect;
import org.noear.solon.data.sqlink.base.dataSource.DataSourceManager;
import org.noear.solon.data.sqlink.base.expression.SqlExpressionFactory;
import org.noear.solon.data.sqlink.base.session.SqlSessionFactory;
import org.noear.solon.data.sqlink.base.toBean.Include.IncludeFactory;
import org.noear.solon.data.sqlink.base.toBean.beancreator.BeanCreatorFactory;
import org.noear.solon.data.sqlink.base.transaction.TransactionManager;
import org.noear.solon.data.sqlink.core.Option;
import org.noear.solon.data.sqlink.core.dialect.DefaultDialect;
import org.noear.solon.data.sqlink.core.dialect.H2Dialect;
import org.noear.solon.data.sqlink.core.dialect.MySQLDialect;
import org.noear.solon.data.sqlink.core.dialect.OracleDialect;
import org.noear.solon.data.sqlink.core.dialect.PostgreSQLDialect;
import org.noear.solon.data.sqlink.core.dialect.SQLiteDialect;
import org.noear.solon.data.sqlink.core.dialect.SqlServerDialect;
import org.noear.solon.data.sqlink.core.expression.h2.H2ExpressionFactory;
import org.noear.solon.data.sqlink.core.expression.mysql.MySqlExpressionFactory;
import org.noear.solon.data.sqlink.core.expression.oracle.OracleExpressionFactory;
import org.noear.solon.data.sqlink.core.expression.pgsql.PostgreSQLExpressionFactory;
import org.noear.solon.data.sqlink.core.expression.sqlite.SqliteExpressionFactory;
import org.noear.solon.data.sqlink.core.expression.sqlserver.SqlServerExpressionFactory;
import org.noear.solon.data.sqlink.core.include.h2.H2IncludeFactory;
import org.noear.solon.data.sqlink.core.include.mysql.MySqlIncludeFactory;
import org.noear.solon.data.sqlink.core.include.oracle.OracleIncludeFactory;
import org.noear.solon.data.sqlink.core.include.sqlserver.SqlServerIncludeFactory;

class Config
implements SqLinkConfig {
    private final Option option;
    private DbType dbType;
    private final TransactionManager transactionManager;
    private final DataSourceManager dataSourceManager;
    private final SqlSessionFactory sqlSessionFactory;
    private final BeanCreatorFactory beanCreatorFactory;
    private final Filter filter = new Filter();
    private SqLinkDialect disambiguation;
    private SqlExpressionFactory sqlExpressionFactory;
    private IncludeFactory includeFactory;

    public Config(Option option, DbType dbType, TransactionManager transactionManager, DataSourceManager dataSourceManager, SqlSessionFactory sqlSessionFactory, BeanCreatorFactory beanCreatorFactory) {
        this.option = option;
        this.dbType = dbType;
        this.beanCreatorFactory = beanCreatorFactory;
        this.disambiguation = this.getIDialectByDbType(dbType);
        this.sqlExpressionFactory = this.getSqlExpressionFactoryByDbType(dbType);
        this.includeFactory = this.getIncludeFactoryByDbType(dbType);
        this.transactionManager = transactionManager;
        this.dataSourceManager = dataSourceManager;
        this.sqlSessionFactory = sqlSessionFactory;
    }

    @Override
    public DataSourceManager getDataSourceManager() {
        return this.dataSourceManager;
    }

    @Override
    public SqLinkDialect getDisambiguation() {
        return this.disambiguation;
    }

    @Override
    public void setDisambiguation(SqLinkDialect disambiguation) {
        this.disambiguation = disambiguation;
    }

    @Override
    public DbType getDbType() {
        return this.dbType;
    }

    @Override
    public boolean isIgnoreUpdateNoWhere() {
        return this.option.isIgnoreUpdateNoWhere();
    }

    @Override
    public boolean isIgnoreDeleteNoWhere() {
        return this.option.isIgnoreDeleteNoWhere();
    }

    @Override
    public boolean isPrintSql() {
        return this.option.isPrintSql();
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    @Override
    public boolean isPrintBatch() {
        return this.option.isPrintBatch();
    }

    @Override
    public SqlExpressionFactory getSqlExpressionFactory() {
        return this.sqlExpressionFactory;
    }

    @Override
    public IncludeFactory getIncludeFactory() {
        return this.includeFactory;
    }

    @Override
    public BeanCreatorFactory getBeanCreatorFactory() {
        return this.beanCreatorFactory;
    }

    @Override
    public void setDbType(DbType dbType) {
        this.dbType = dbType;
        this.disambiguation = this.getIDialectByDbType(dbType);
        this.sqlExpressionFactory = this.getSqlExpressionFactoryByDbType(dbType);
        this.includeFactory = this.getIncludeFactoryByDbType(dbType);
    }

    private SqLinkDialect getIDialectByDbType(DbType dbType) {
        switch (dbType) {
            case Any: {
                return new DefaultDialect();
            }
            case MySQL: {
                return new MySQLDialect();
            }
            case SQLServer: {
                return new SqlServerDialect();
            }
            case H2: {
                return new H2Dialect();
            }
            case Oracle: {
                return new OracleDialect();
            }
            case SQLite: {
                return new SQLiteDialect();
            }
            case PostgreSQL: {
                return new PostgreSQLDialect();
            }
        }
        throw new RuntimeException(dbType.name());
    }

    public SqlExpressionFactory getSqlExpressionFactoryByDbType(DbType dbType) {
        switch (dbType) {
            case Any: 
            case MySQL: {
                return new MySqlExpressionFactory();
            }
            case SQLServer: {
                return new SqlServerExpressionFactory();
            }
            case H2: {
                return new H2ExpressionFactory();
            }
            case Oracle: {
                return new OracleExpressionFactory();
            }
            case SQLite: {
                return new SqliteExpressionFactory();
            }
            case PostgreSQL: {
                return new PostgreSQLExpressionFactory();
            }
        }
        throw new RuntimeException(dbType.name());
    }

    public IncludeFactory getIncludeFactoryByDbType(DbType dbType) {
        switch (dbType) {
            case Any: 
            case MySQL: 
            case SQLite: 
            case PostgreSQL: {
                return new MySqlIncludeFactory();
            }
            case SQLServer: {
                return new SqlServerIncludeFactory();
            }
            case H2: {
                return new H2IncludeFactory();
            }
            case Oracle: {
                return new OracleIncludeFactory();
            }
        }
        throw new RuntimeException(dbType.name());
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }
}

