/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.base.toBean.build;

import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.intercept.Interceptor;
import org.noear.solon.data.sqlink.base.metaData.FieldMetaData;
import org.noear.solon.data.sqlink.base.toBean.beancreator.AbsBeanCreator;
import org.noear.solon.data.sqlink.base.toBean.beancreator.ISetterCaller;
import org.noear.solon.data.sqlink.base.toBean.handler.ITypeHandler;
import org.noear.solon.data.sqlink.base.toBean.handler.TypeHandlerManager;
import org.noear.solon.data.sqlink.core.visitor.ExpressionUtil;

public class ObjectBuilder<T> {
    private final ResultSet resultSet;
    private final Class<T> target;
    private final List<FieldMetaData> fieldMetaDataList;
    private final boolean isSingle;
    private final SqLinkConfig config;

    public static <T> ObjectBuilder<T> start(ResultSet resultSet, Class<T> target, List<FieldMetaData> fieldMetaDataList, boolean isSingle, SqLinkConfig config) {
        return new ObjectBuilder<T>(resultSet, target, fieldMetaDataList, isSingle, config);
    }

    private ObjectBuilder(ResultSet resultSet, Class<T> target, List<FieldMetaData> fieldMetaDataList, boolean isSingle, SqLinkConfig config) {
        this.resultSet = resultSet;
        this.target = target;
        this.fieldMetaDataList = fieldMetaDataList;
        this.isSingle = isSingle;
        this.config = config;
    }

    public <Key> Map<Key, T> createMap(String column) throws SQLException, InvocationTargetException, IllegalAccessException {
        AbsBeanCreator<T> beanCreator = this.config.getBeanCreatorFactory().get(this.target);
        Supplier<T> creator = beanCreator.getBeanCreator();
        Map<String, Integer> indexMap = this.getIndexMap();
        HashMap<Object, T> hashMap = new HashMap<Object, T>();
        while (this.resultSet.next()) {
            T t = creator.get();
            Object key = null;
            for (FieldMetaData metaData : this.fieldMetaDataList) {
                Object value = this.convertValue(metaData, indexMap.get(metaData.getColumn()));
                if (column.equals(metaData.getColumn())) {
                    key = value;
                }
                if (value == null) continue;
                metaData.getSetter().invoke(t, value);
            }
            if (key == null) continue;
            hashMap.put(key, t);
        }
        return hashMap;
    }

    public <Key> Map<Key, List<T>> createMapList(String keyColumn) throws SQLException, InvocationTargetException, IllegalAccessException {
        AbsBeanCreator<T> beanCreator = this.config.getBeanCreatorFactory().get(this.target);
        Supplier<T> creator = beanCreator.getBeanCreator();
        Map<String, Integer> indexMap = this.getIndexMap();
        HashMap hashMap = new HashMap();
        while (this.resultSet.next()) {
            T t = creator.get();
            Object key = null;
            for (FieldMetaData metaData : this.fieldMetaDataList) {
                String column = metaData.getColumn();
                Object value = this.convertValue(metaData, indexMap.get(column));
                if (keyColumn.equals(metaData.getColumn())) {
                    key = value;
                }
                if (value == null) continue;
                metaData.getSetter().invoke(t, value);
            }
            if (key == null) continue;
            if (!hashMap.containsKey(key)) {
                ArrayList<T> tempList = new ArrayList<T>();
                tempList.add(t);
                hashMap.put(key, tempList);
                continue;
            }
            ((List)hashMap.get(key)).add(t);
        }
        return hashMap;
    }

    public <Key> Map<Key, List<T>> createMapListByAnotherKey(FieldMetaData anotherKeyColumn) throws SQLException, InvocationTargetException, IllegalAccessException {
        AbsBeanCreator<T> beanCreator = this.config.getBeanCreatorFactory().get(this.target);
        Supplier<T> creator = beanCreator.getBeanCreator();
        Map<String, Integer> indexMap = this.getIndexMap();
        int anotherKeyIndex = indexMap.get(anotherKeyColumn.getColumn());
        HashMap hashMap = new HashMap();
        while (this.resultSet.next()) {
            T t = creator.get();
            Object key = this.convertValue(anotherKeyColumn, anotherKeyIndex);
            for (FieldMetaData metaData : this.fieldMetaDataList) {
                Object value = this.convertValue(metaData, indexMap.get(metaData.getColumn()));
                if (value == null) continue;
                metaData.getSetter().invoke(t, value);
            }
            if (!hashMap.containsKey(key)) {
                ArrayList<T> tempList = new ArrayList<T>();
                tempList.add(t);
                hashMap.put(key, tempList);
                continue;
            }
            ((List)hashMap.get(key)).add(t);
        }
        return hashMap;
    }

    public List<T> createList() throws SQLException, NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        if (this.isSingle) {
            return this.getSingleList();
        }
        return this.getClassList();
    }

    private List<T> getSingleList() throws SQLException {
        ArrayList list = new ArrayList();
        ITypeHandler typeHandler = TypeHandlerManager.get(this.target);
        while (this.resultSet.next()) {
            Object t = typeHandler.getValue(this.resultSet, 1, this.target);
            list.add(t);
        }
        return list;
    }

    private List<T> getClassList() throws SQLException, IllegalAccessException, InvocationTargetException {
        AbsBeanCreator<T> beanCreator = this.config.getBeanCreatorFactory().get(this.target);
        Supplier<T> creator = beanCreator.getBeanCreator();
        Map<String, Integer> indexMap = this.getIndexMap();
        ArrayList<T> list = new ArrayList<T>();
        while (this.resultSet.next()) {
            T t = creator.get();
            for (FieldMetaData metaData : this.fieldMetaDataList) {
                Object value = this.convertValue(metaData, indexMap.get(metaData.getColumn()));
                if (value == null) continue;
                ISetterCaller<T> beanSetter = beanCreator.getBeanSetter(metaData.getProperty());
                beanSetter.call(t, value);
            }
            list.add(t);
        }
        return list;
    }

    private Map<String, Integer> getIndexMap() throws SQLException {
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
        ResultSetMetaData resultSetMetaData = this.resultSet.getMetaData();
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            String columnLabel = resultSetMetaData.getColumnLabel(i);
            indexMap.put(columnLabel, i);
        }
        return indexMap;
    }

    private Object convertValue(FieldMetaData metaData, int index) throws SQLException {
        ITypeHandler<?> typeHandler = metaData.getTypeHandler();
        Object value = typeHandler.getValue(this.resultSet, index, metaData.getGenericType());
        Interceptor<?> onSelectGet = metaData.getOnGet();
        return onSelectGet.doIntercept(ExpressionUtil.cast(value), this.config);
    }
}

