/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core.expression.oracle;

import java.util.List;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlQueryableExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlTableExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlWithExpression;
import org.noear.solon.data.sqlink.base.expression.impl.SqlFromExpression;
import org.noear.solon.data.sqlink.base.session.SqlValue;

public class OracleFromExpression
extends SqlFromExpression {
    public OracleFromExpression(ISqlTableExpression sqlTableExpression, String asName) {
        super(sqlTableExpression, asName);
    }

    @Override
    public String getSqlAndValue(SqLinkConfig config, List<SqlValue> values) {
        if (this.isEmptyTable()) {
            return "FROM " + config.getDisambiguation().disambiguationTableName("DUAL");
        }
        StringBuilder builder = new StringBuilder();
        if (this.sqlTableExpression instanceof ISqlWithExpression) {
            ISqlWithExpression withExpression = (ISqlWithExpression)this.sqlTableExpression;
            builder.append(withExpression.withTableName());
        } else {
            builder.append(this.sqlTableExpression.getSqlAndValue(config, values));
        }
        if (this.sqlTableExpression instanceof ISqlQueryableExpression) {
            builder.insert(0, "(");
            builder.append(")");
        }
        if (this.asName != null) {
            return "FROM " + builder + config.getDisambiguation().disambiguation(this.asName);
        }
        return "FROM " + builder;
    }
}

