/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.base.session;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.dataSource.DataSourceManager;
import org.noear.solon.data.sqlink.base.session.SqlSession;
import org.noear.solon.data.sqlink.base.session.SqlValue;
import org.noear.solon.data.sqlink.base.transaction.TransactionManager;

public class DefaultSqlSession
implements SqlSession {
    protected final SqLinkConfig config;
    protected final DataSourceManager dataSourceManager;
    protected final TransactionManager transactionManager;

    public DefaultSqlSession(SqLinkConfig config, DataSourceManager dataSourceManager, TransactionManager transactionManager) {
        this.config = config;
        this.dataSourceManager = dataSourceManager;
        this.transactionManager = transactionManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <R> R executeQuery(SqlSession.Function<ResultSet, R> func, String sql, Collection<SqlValue> sqlValues) {
        if (!this.transactionManager.currentThreadInTransaction()) {
            try (Connection connection = this.dataSourceManager.getConnection();){
                R r = this.executeQuery(connection, func, sql, sqlValues);
                return r;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Connection connection;
            if (this.transactionManager.isOpenTransaction()) {
                connection = this.transactionManager.getCurTransaction().getConnection();
                return this.executeQuery(connection, func, sql, sqlValues);
            }
            connection = this.dataSourceManager.getConnection();
            return this.executeQuery(connection, func, sql, sqlValues);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Exception decompiling
     */
    private <R> R executeQuery(Connection connection, SqlSession.Function<ResultSet, R> func, String sql, Collection<SqlValue> sqlValues) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long executeInsert(String sql, Collection<SqlValue> sqlValues, int length) {
        if (!this.transactionManager.currentThreadInTransaction()) {
            try (Connection connection = this.dataSourceManager.getConnection();){
                long l = this.executeInsert(connection, sql, sqlValues, length);
                return l;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Connection connection;
            if (this.transactionManager.isOpenTransaction()) {
                connection = this.transactionManager.getCurTransaction().getConnection();
                return this.executeInsert(connection, sql, sqlValues, length);
            }
            connection = this.dataSourceManager.getConnection();
            return this.executeInsert(connection, sql, sqlValues, length);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long executeDelete(String sql, Collection<SqlValue> sqlValues) {
        return this.executeUpdate(sql, sqlValues);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long executeUpdate(String sql, Collection<SqlValue> sqlValues) {
        if (!this.transactionManager.currentThreadInTransaction()) {
            try (Connection connection = this.dataSourceManager.getConnection();){
                long l = this.executeUpdate(connection, sql, sqlValues);
                return l;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Connection connection;
            if (this.transactionManager.isOpenTransaction()) {
                connection = this.transactionManager.getCurTransaction().getConnection();
                return this.executeUpdate(connection, sql, sqlValues);
            }
            connection = this.dataSourceManager.getConnection();
            return this.executeUpdate(connection, sql, sqlValues);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long executeInsert(Connection connection, String sql, Collection<SqlValue> sqlValues, int length) {
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            boolean batch = this.setObjects(preparedStatement, sqlValues, length);
            if (batch) {
                long l = preparedStatement.executeBatch().length;
                return l;
            }
            long l = preparedStatement.executeUpdate();
            return l;
        }
        catch (IllegalAccessException | InvocationTargetException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long executeUpdate(Connection connection, String sql, Collection<SqlValue> sqlValues) {
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            this.setObjects(preparedStatement, sqlValues);
            long l = preparedStatement.executeUpdate();
            return l;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected void setObjects(PreparedStatement preparedStatement, Collection<SqlValue> sqlValues) throws SQLException {
        int index = 1;
        for (SqlValue sqlValue : sqlValues) {
            sqlValue.preparedStatementSetValue(this.config, preparedStatement, index++);
        }
    }

    protected boolean setObjects(PreparedStatement preparedStatement, Collection<SqlValue> sqlValues, int length) throws SQLException, InvocationTargetException, IllegalAccessException {
        int size = sqlValues.size();
        boolean batch = size > length;
        int index = 1;
        for (SqlValue sqlValue : sqlValues) {
            sqlValue.preparedStatementSetValue(this.config, preparedStatement, index++);
            if (index <= length || !batch) continue;
            index = 1;
            preparedStatement.addBatch();
        }
        return batch;
    }
}

