/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.base.metaData;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.noear.solon.data.sqlink.annotation.Column;
import org.noear.solon.data.sqlink.annotation.EmptyTable;
import org.noear.solon.data.sqlink.annotation.IgnoreColumn;
import org.noear.solon.data.sqlink.annotation.InsertDefaultValue;
import org.noear.solon.data.sqlink.annotation.Navigate;
import org.noear.solon.data.sqlink.annotation.OnGet;
import org.noear.solon.data.sqlink.annotation.OnPut;
import org.noear.solon.data.sqlink.annotation.Table;
import org.noear.solon.data.sqlink.annotation.UseTypeHandler;
import org.noear.solon.data.sqlink.api.crud.read.Empty;
import org.noear.solon.data.sqlink.base.intercept.DoNothingInterceptor;
import org.noear.solon.data.sqlink.base.intercept.Interceptor;
import org.noear.solon.data.sqlink.base.intercept.NoInterceptor;
import org.noear.solon.data.sqlink.base.metaData.FieldMetaData;
import org.noear.solon.data.sqlink.base.metaData.NavigateData;
import org.noear.solon.data.sqlink.base.toBean.handler.ITypeHandler;
import org.noear.solon.data.sqlink.base.toBean.handler.TypeHandlerManager;
import org.noear.solon.data.sqlink.core.exception.SqLinkException;
import org.noear.solon.data.sqlink.core.exception.SqLinkNotFoundFieldException;
import org.noear.solon.data.sqlink.core.visitor.ExpressionUtil;

public class MetaData {
    private final List<FieldMetaData> propertys = new ArrayList<FieldMetaData>();
    private final Class<?> type;
    private final Constructor<?> constructor;
    private final String tableName;
    private final String schema;
    private final boolean isEmptyTable;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MetaData(Class<?> type) {
        try {
            this.type = type;
            this.constructor = !type.isAnonymousClass() ? type.getConstructor(new Class[0]) : null;
            Table table = type.getAnnotation(Table.class);
            this.tableName = this.hasTableName(table) ? table.value() : (type.isAnonymousClass() ? type.getSuperclass().getSimpleName() : type.getSimpleName());
            this.schema = table == null ? "" : table.schema();
            this.isEmptyTable = type.isAnnotationPresent(EmptyTable.class);
            for (PropertyDescriptor descriptor : this.propertyDescriptors(type)) {
                DoNothingInterceptor<?> onGetInterceptor;
                String property = descriptor.getName();
                Field field = type.getDeclaredField(property);
                Column column = field.getAnnotation(Column.class);
                boolean notNull = column != null && column.notNull();
                String columnStr = column == null || column.value().isEmpty() ? property : column.value();
                UseTypeHandler useTypeHandler = field.getAnnotation(UseTypeHandler.class);
                boolean isUseTypeHandler = useTypeHandler != null;
                ITypeHandler typeHandler = useTypeHandler == null ? TypeHandlerManager.get(field.getGenericType()) : TypeHandlerManager.getByHandlerType((Class)ExpressionUtil.cast(useTypeHandler.value()));
                NavigateData navigateData = null;
                Navigate navigate = field.getAnnotation(Navigate.class);
                boolean isPrimaryKey = column != null && column.primaryKey();
                InsertDefaultValue insertDefaultValue = field.getAnnotation(InsertDefaultValue.class);
                OnPut onPut = field.getAnnotation(OnPut.class);
                DoNothingInterceptor<?> onPutInterceptor = onPut == null || onPut.value() == NoInterceptor.class ? DoNothingInterceptor.Instance : Interceptor.get((Class)ExpressionUtil.cast(onPut.value()));
                OnGet onGet = field.getAnnotation(OnGet.class);
                Interceptor interceptor = onGetInterceptor = onGet == null || onGet.value() == NoInterceptor.class ? DoNothingInterceptor.Instance : Interceptor.get((Class)ExpressionUtil.cast(onGet.value()));
                if (navigate != null) {
                    if (Collection.class.isAssignableFrom(field.getType())) {
                        Class navigateTargetType;
                        Class<?> collectionType = field.getType();
                        if (type.isAnonymousClass()) {
                            Class aClass = navigate.targetType();
                            if (aClass == Empty.class) throw new SqLinkException("\u533f\u540d\u7c7b\u5b57\u6bb5\u4e0a\u7684@Navigate\u6ce8\u89e3\u7684targetType\u4e0d\u80fd\u4e3a\u7a7a:" + field);
                            navigateTargetType = aClass;
                            navigateData = new NavigateData(navigate, navigateTargetType, collectionType);
                        } else {
                            Type genericType = field.getGenericType();
                            navigateTargetType = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
                            navigateData = new NavigateData(navigate, navigateTargetType, collectionType);
                        }
                    } else {
                        Class<?> navigateTargetType = field.getType();
                        navigateData = new NavigateData(navigate, navigateTargetType, null);
                    }
                }
                boolean ignoreColumn = field.getAnnotation(IgnoreColumn.class) != null || navigateData != null;
                this.propertys.add(new FieldMetaData(notNull, property, columnStr, descriptor.getReadMethod(), descriptor.getWriteMethod(), field, isUseTypeHandler, typeHandler, ignoreColumn, navigateData, isPrimaryKey, insertDefaultValue, onPutInterceptor, onGetInterceptor));
            }
            return;
        }
        catch (NoSuchFieldException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean hasTableName(Table table) {
        return table != null && !table.value().isEmpty();
    }

    private PropertyDescriptor[] propertyDescriptors(Class<?> c) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(c, Object.class);
            return beanInfo.getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }

    public List<FieldMetaData> getPropertys() {
        return this.propertys;
    }

    public List<FieldMetaData> getNotIgnorePropertys() {
        return this.propertys.stream().filter(f -> !f.isIgnoreColumn()).collect(Collectors.toList());
    }

    public FieldMetaData getFieldMetaDataByFieldName(String key) {
        return this.propertys.stream().filter(f -> f.getProperty().equals(key)).findFirst().orElseThrow(() -> new SqLinkNotFoundFieldException(key));
    }

    public FieldMetaData getFieldMetaDataByColumnName(String columnName) {
        return this.propertys.stream().filter(f -> f.getColumn().equals(columnName)).findFirst().orElseThrow(() -> new SqLinkNotFoundFieldException(columnName));
    }

    public FieldMetaData getFieldMetaDataByGetter(Method getter) {
        return this.propertys.stream().filter(f -> f.getGetter().equals(getter)).findFirst().orElseThrow(() -> new SqLinkNotFoundFieldException(getter));
    }

    public FieldMetaData getFieldMetaDataBySetter(Method setter) {
        return this.propertys.stream().filter(f -> f.getSetter().equals(setter)).findFirst().orElseThrow(() -> new SqLinkNotFoundFieldException(setter));
    }

    public String getColumnNameByGetter(Method getter) {
        return this.propertys.stream().filter(f -> f.getGetter().equals(getter)).findFirst().orElseThrow(() -> new SqLinkNotFoundFieldException(getter)).getColumn();
    }

    public String getColumnNameBySetter(Method setter) {
        return this.propertys.stream().filter(f -> f.getSetter().equals(setter)).findFirst().orElseThrow(() -> new SqLinkNotFoundFieldException(setter)).getColumn();
    }

    public FieldMetaData getPrimary() {
        return this.propertys.stream().filter(f -> f.isPrimaryKey()).findFirst().orElseThrow(() -> new SqLinkNotFoundFieldException(this.type + "\u627e\u4e0d\u5230\u4e3b\u952e"));
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchema() {
        return this.schema;
    }

    public boolean isEmptyTable() {
        return this.isEmptyTable;
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }
}

