/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.api.crud.delete;

import io.github.kiryu1223.expressionTree.expressions.LambdaExpression;
import java.util.ArrayList;
import org.noear.solon.data.sqlink.api.crud.CRUD;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.JoinType;
import org.noear.solon.data.sqlink.base.expression.SqlExpressionFactory;
import org.noear.solon.data.sqlink.base.session.SqlSession;
import org.noear.solon.data.sqlink.base.session.SqlValue;
import org.noear.solon.data.sqlink.core.sqlBuilder.DeleteSqlBuilder;
import org.noear.solon.data.sqlink.core.visitor.SqlVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DeleteBase
extends CRUD {
    public static final Logger log = LoggerFactory.getLogger(DeleteBase.class);
    private final DeleteSqlBuilder sqlBuilder;

    public DeleteBase(SqLinkConfig config, Class<?> target) {
        this.sqlBuilder = new DeleteSqlBuilder(config, target);
    }

    public DeleteBase(DeleteSqlBuilder sqlBuilder) {
        this.sqlBuilder = sqlBuilder;
    }

    protected DeleteSqlBuilder getSqlBuilder() {
        return this.sqlBuilder;
    }

    @Override
    public SqLinkConfig getConfig() {
        return this.sqlBuilder.getConfig();
    }

    public long executeRows() {
        this.checkHasWhere();
        SqLinkConfig config = this.getConfig();
        ArrayList<SqlValue> sqlValues = new ArrayList<SqlValue>();
        String sql = this.sqlBuilder.getSqlAndValue(sqlValues);
        this.tryPrintSql(log, sql);
        SqlSession session = config.getSqlSessionFactory().getSession(config);
        return session.executeDelete(sql, sqlValues);
    }

    @Override
    public String toSql() {
        return this.sqlBuilder.getSql();
    }

    private void checkHasWhere() {
        if (this.getConfig().isIgnoreDeleteNoWhere()) {
            return;
        }
        if (!this.sqlBuilder.hasWhere()) {
            throw new RuntimeException("DELETE\u6ca1\u6709\u6761\u4ef6");
        }
    }

    protected void join(JoinType joinType, Class<?> target, LambdaExpression<?> lambda) {
        SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
        SqlVisitor sqlVisitor = new SqlVisitor(this.getConfig());
        Object on = sqlVisitor.visit((LambdaExpression)lambda);
        this.getSqlBuilder().addJoin(joinType, factory.table(target), (ISqlExpression)on);
    }

    protected void selectDeleteTable(Class<?> c) {
        this.getSqlBuilder().addExclude(c);
    }

    protected void where(LambdaExpression<?> lambda) {
        SqlVisitor sqlVisitor = new SqlVisitor(this.getConfig());
        Object expression = sqlVisitor.visit((LambdaExpression)lambda);
        this.sqlBuilder.addWhere((ISqlExpression)expression);
    }
}

