/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core.sqlBuilder;

import java.util.ArrayList;
import java.util.List;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.SqLinkDialect;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlJoinExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlJoinsExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSetExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSetsExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlTableExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlWhereExpression;
import org.noear.solon.data.sqlink.base.expression.JoinType;
import org.noear.solon.data.sqlink.base.expression.SqlExpressionFactory;
import org.noear.solon.data.sqlink.base.metaData.MetaData;
import org.noear.solon.data.sqlink.base.metaData.MetaDataCache;
import org.noear.solon.data.sqlink.base.session.SqlValue;
import org.noear.solon.data.sqlink.core.sqlBuilder.ISqlBuilder;

public class UpdateSqlBuilder
implements ISqlBuilder {
    private final SqLinkConfig config;
    private final ISqlJoinsExpression joins;
    private final ISqlSetsExpression sets;
    private final ISqlWhereExpression wheres;
    private final Class<?> target;
    private final SqlExpressionFactory factory;

    public UpdateSqlBuilder(SqLinkConfig config, Class<?> target) {
        this.config = config;
        this.target = target;
        this.factory = config.getSqlExpressionFactory();
        this.joins = this.factory.Joins();
        this.sets = this.factory.sets();
        this.wheres = this.factory.where();
    }

    public void addJoin(JoinType joinType, ISqlTableExpression table, ISqlExpression on) {
        String as = MetaDataCache.getMetaData(table.getMainTableClass()).getTableName().substring(0, 1).toLowerCase();
        ISqlJoinExpression join = this.factory.join(joinType, table, on, as);
        this.joins.addJoin(join);
    }

    public void addSet(ISqlSetsExpression set) {
        this.sets.addSet(set.getSets());
    }

    public void addSet(ISqlSetExpression set) {
        this.sets.addSet(set);
    }

    public void addWhere(ISqlExpression where) {
        this.wheres.addCondition(where);
    }

    public boolean hasWhere() {
        return !this.wheres.isEmpty();
    }

    @Override
    public String getSql() {
        return this.makeUpdate();
    }

    @Override
    public String getSqlAndValue(List<SqlValue> sqlValues) {
        return this.makeUpdate(sqlValues);
    }

    @Override
    public SqLinkConfig getConfig() {
        return this.config;
    }

    private String makeUpdate() {
        return this.makeUpdate(null);
    }

    private String makeUpdate(List<SqlValue> sqlValues) {
        MetaData metaData = MetaDataCache.getMetaData(this.target);
        SqLinkDialect dbConfig = this.config.getDisambiguation();
        String sql = "UPDATE " + dbConfig.disambiguationTableName(metaData.getTableName()) + " AS t0";
        ArrayList<String> sb = new ArrayList<String>();
        sb.add(sql);
        String joinsSqlAndValue = this.joins.getSqlAndValue(this.config, sqlValues);
        if (!joinsSqlAndValue.isEmpty()) {
            sb.add(joinsSqlAndValue);
        }
        String sqlAndValue = this.sets.getSqlAndValue(this.config, sqlValues);
        sb.add(sqlAndValue);
        String wheresSqlAndValue = this.wheres.getSqlAndValue(this.config, sqlValues);
        if (!wheresSqlAndValue.isEmpty()) {
            sb.add(wheresSqlAndValue);
        }
        return String.join((CharSequence)" ", sb);
    }
}

