/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core;

import org.noear.solon.data.sqlink.SqLink;
import org.noear.solon.data.sqlink.base.DbType;
import org.noear.solon.data.sqlink.base.SqLinkDialect;
import org.noear.solon.data.sqlink.base.dataSource.DataSourceManager;
import org.noear.solon.data.sqlink.base.session.DefaultSqlSessionFactory;
import org.noear.solon.data.sqlink.base.session.SqlSessionFactory;
import org.noear.solon.data.sqlink.base.toBean.beancreator.BeanCreatorFactory;
import org.noear.solon.data.sqlink.base.transaction.DefaultTransactionManager;
import org.noear.solon.data.sqlink.base.transaction.TransactionManager;
import org.noear.solon.data.sqlink.core.Config;
import org.noear.solon.data.sqlink.core.Option;
import org.noear.solon.data.sqlink.core.SqLinkImpl;

public class SqLinkBuilder {
    private SqLinkDialect dialect;
    private Option option = new Option();
    private DataSourceManager dataSourceManager;
    private TransactionManager transactionManager;
    private SqlSessionFactory sqlSessionFactory;
    private BeanCreatorFactory beanCreatorFactory;

    public SqLink build() {
        if (this.dataSourceManager == null) {
            throw new NullPointerException("dataSourceManager is null");
        }
        if (this.transactionManager == null) {
            this.transactionManager = new DefaultTransactionManager(this.dataSourceManager);
        }
        if (this.sqlSessionFactory == null) {
            this.sqlSessionFactory = new DefaultSqlSessionFactory(this.dataSourceManager, this.transactionManager);
        }
        if (this.beanCreatorFactory == null) {
            this.beanCreatorFactory = new BeanCreatorFactory();
        }
        Config config = new Config(this.option, DbType.Any, this.transactionManager, this.dataSourceManager, this.sqlSessionFactory, this.beanCreatorFactory);
        if (this.dialect != null) {
            config.setDisambiguation(this.dialect);
        }
        return new SqLinkImpl(config);
    }

    public SqLinkBuilder setDataSourceManager(DataSourceManager dataSourceManager) {
        this.dataSourceManager = dataSourceManager;
        return this;
    }

    public SqLinkBuilder setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
        return this;
    }

    public SqLinkBuilder setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
        return this;
    }

    public SqLinkBuilder setOption(Option option) {
        this.option = option;
        return this;
    }

    public SqLinkBuilder setBeanCreatorFactory(BeanCreatorFactory beanCreatorFactory) {
        this.beanCreatorFactory = beanCreatorFactory;
        return this;
    }

    public SqLinkBuilder setDialect(SqLinkDialect dialect) {
        this.dialect = dialect;
        return this;
    }
}

