/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core.expression.sqlserver;

import java.util.ArrayList;
import java.util.List;
import org.noear.solon.data.sqlink.base.DbType;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlFromExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlGroupByExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlHavingExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlJoinsExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlLimitExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlOrderByExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSelectExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlWhereExpression;
import org.noear.solon.data.sqlink.base.expression.SqlExpressionFactory;
import org.noear.solon.data.sqlink.base.expression.impl.SqlQueryableExpression;
import org.noear.solon.data.sqlink.base.metaData.FieldMetaData;
import org.noear.solon.data.sqlink.base.metaData.MetaData;
import org.noear.solon.data.sqlink.base.metaData.MetaDataCache;
import org.noear.solon.data.sqlink.base.session.SqlValue;
import org.noear.solon.data.sqlink.core.exception.SqLinkLimitNotFoundOrderByException;

public class SqlServerQueryableExpression
extends SqlQueryableExpression {
    protected SqlServerQueryableExpression(ISqlSelectExpression select, ISqlFromExpression from, ISqlJoinsExpression joins, ISqlWhereExpression where, ISqlGroupByExpression groupBy, ISqlHavingExpression having, ISqlOrderByExpression orderBy, ISqlLimitExpression limit) {
        super(select, from, joins, where, groupBy, having, orderBy, limit);
    }

    @Override
    public String getSqlAndValue(SqLinkConfig config, List<SqlValue> values) {
        String limitSqlAndValue;
        String orderBySqlAndValue;
        String havingSqlAndValue;
        String groupBySqlAndValue;
        String whereSqlAndValue;
        String joinsSqlAndValue;
        ArrayList<String> strings = new ArrayList<String>();
        this.makeSelect(strings, values, config);
        String fromSqlAndValue = this.from.getSqlAndValue(config, values);
        if (!fromSqlAndValue.isEmpty()) {
            strings.add(fromSqlAndValue);
        }
        if (!(joinsSqlAndValue = this.joins.getSqlAndValue(config, values)).isEmpty()) {
            strings.add(joinsSqlAndValue);
        }
        if (!(whereSqlAndValue = this.where.getSqlAndValue(config, values)).isEmpty()) {
            strings.add(whereSqlAndValue);
        }
        if (!(groupBySqlAndValue = this.groupBy.getSqlAndValue(config, values)).isEmpty()) {
            strings.add(groupBySqlAndValue);
        }
        if (!(havingSqlAndValue = this.having.getSqlAndValue(config, values)).isEmpty()) {
            strings.add(havingSqlAndValue);
        }
        if (!(orderBySqlAndValue = this.orderBy.getSqlAndValue(config, values)).isEmpty()) {
            strings.add(orderBySqlAndValue);
        }
        if (!this.from.isEmptyTable() && this.limit.hasRowsAndOffset() && this.orderBy.isEmpty()) {
            this.addOrder(strings, values, config);
        }
        if (!(limitSqlAndValue = this.limit.getSqlAndValue(config, values)).isEmpty()) {
            strings.add(limitSqlAndValue);
        }
        return String.join((CharSequence)" ", strings);
    }

    private void addOrder(List<String> strings, List<SqlValue> values, SqLinkConfig config) {
        MetaData metaData = MetaDataCache.getMetaData(this.from.getSqlTableExpression().getTableClass());
        FieldMetaData primary = metaData.getPrimary();
        if (primary == null) {
            throw new SqLinkLimitNotFoundOrderByException(DbType.SQLServer);
        }
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        ISqlOrderByExpression sqlOrderByExpression = factory.orderBy();
        sqlOrderByExpression.addOrder(factory.order(factory.column(primary)));
        strings.add(sqlOrderByExpression.getSqlAndValue(config, values));
    }

    private void makeSelect(List<String> strings, List<SqlValue> values, SqLinkConfig config) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("SELECT");
        if (this.select.isDistinct()) {
            result.add("DISTINCT");
        }
        if (!this.from.isEmptyTable() && this.limit.onlyHasRows()) {
            result.add("TOP(" + this.limit.getRows() + ")");
        }
        List<ISqlExpression> columns = this.select.getColumns();
        ArrayList<String> columnsStr = new ArrayList<String>(columns.size());
        for (ISqlExpression sqlExpression : columns) {
            columnsStr.add(sqlExpression.getSqlAndValue(config, values));
        }
        result.add(String.join((CharSequence)",", columnsStr));
        strings.add(String.join((CharSequence)" ", result));
    }
}

