/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.api.crud.update;

import io.github.kiryu1223.expressionTree.expressions.ExprTree;
import io.github.kiryu1223.expressionTree.expressions.LambdaExpression;
import java.util.ArrayList;
import org.noear.solon.data.sqlink.api.crud.CRUD;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlRealTableExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSetExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSetsExpression;
import org.noear.solon.data.sqlink.base.expression.JoinType;
import org.noear.solon.data.sqlink.base.expression.SqlExpressionFactory;
import org.noear.solon.data.sqlink.base.session.SqlSession;
import org.noear.solon.data.sqlink.base.session.SqlValue;
import org.noear.solon.data.sqlink.core.exception.SqLinkException;
import org.noear.solon.data.sqlink.core.sqlBuilder.UpdateSqlBuilder;
import org.noear.solon.data.sqlink.core.visitor.NormalVisitor;
import org.noear.solon.data.sqlink.core.visitor.SetVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateBase
extends CRUD {
    public static final Logger log = LoggerFactory.getLogger(UpdateBase.class);
    private final UpdateSqlBuilder sqlBuilder;

    public UpdateBase(SqLinkConfig config, Class<?> target) {
        this.sqlBuilder = new UpdateSqlBuilder(config, target);
    }

    public UpdateBase(UpdateSqlBuilder sqlBuilder) {
        this.sqlBuilder = sqlBuilder;
    }

    protected UpdateSqlBuilder getSqlBuilder() {
        return this.sqlBuilder;
    }

    @Override
    protected SqLinkConfig getConfig() {
        return this.sqlBuilder.getConfig();
    }

    @Override
    public String toSql() {
        return this.sqlBuilder.getSql();
    }

    public long executeRows() {
        this.checkHasWhere();
        SqLinkConfig config = this.getConfig();
        ArrayList<SqlValue> sqlValues = new ArrayList<SqlValue>();
        String sql = this.sqlBuilder.getSqlAndValue(sqlValues);
        this.tryPrintSql(log, sql);
        SqlSession session = config.getSqlSessionFactory().getSession(config);
        return session.executeUpdate(sql, sqlValues);
    }

    private void checkHasWhere() {
        if (this.getConfig().isIgnoreUpdateNoWhere()) {
            return;
        }
        if (!this.sqlBuilder.hasWhere()) {
            throw new SqLinkException("UPDATE\u6ca1\u6709\u6761\u4ef6");
        }
    }

    protected void join(JoinType joinType, Class<?> target, ExprTree<?> expr) {
        SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
        NormalVisitor normalVisitor = new NormalVisitor(this.getConfig());
        Object on = normalVisitor.visit(expr.getTree());
        ISqlRealTableExpression table = factory.table(target);
        this.getSqlBuilder().addJoin(joinType, table, (ISqlExpression)on);
    }

    protected void set(LambdaExpression<?> lambda) {
        SetVisitor setVisitor = new SetVisitor(this.getConfig());
        Object expression = setVisitor.visit((LambdaExpression)lambda);
        if (expression instanceof ISqlSetsExpression) {
            ISqlSetsExpression sqlSetsExpression = (ISqlSetsExpression)expression;
            this.sqlBuilder.addSet(sqlSetsExpression);
        } else if (expression instanceof ISqlSetExpression) {
            ISqlSetExpression sqlSetExpression = (ISqlSetExpression)expression;
            this.sqlBuilder.addSet(sqlSetExpression);
        }
    }

    protected void where(LambdaExpression<?> lambda) {
        NormalVisitor normalVisitor = new NormalVisitor(this.getConfig());
        Object expression = normalVisitor.visit((LambdaExpression)lambda);
        this.sqlBuilder.addWhere((ISqlExpression)expression);
    }
}

