/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.base.toBean.build;

import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.noear.solon.data.sqlink.base.IConfig;
import org.noear.solon.data.sqlink.base.metaData.PropertyMetaData;
import org.noear.solon.data.sqlink.base.toBean.beancreator.AbsBeanCreator;
import org.noear.solon.data.sqlink.base.toBean.beancreator.ISetterCaller;
import org.noear.solon.data.sqlink.base.toBean.handler.ITypeHandler;
import org.noear.solon.data.sqlink.base.toBean.handler.TypeHandlerManager;

public class ObjectBuilder<T> {
    private final ResultSet resultSet;
    private final Class<T> target;
    private final List<PropertyMetaData> propertyMetaDataList;
    private final boolean isSingle;
    private final IConfig config;

    public static <T> ObjectBuilder<T> start(ResultSet resultSet, Class<T> target, List<PropertyMetaData> propertyMetaDataList, boolean isSingle, IConfig config) {
        return new ObjectBuilder<T>(resultSet, target, propertyMetaDataList, isSingle, config);
    }

    private ObjectBuilder(ResultSet resultSet, Class<T> target, List<PropertyMetaData> propertyMetaDataList, boolean isSingle, IConfig config) {
        this.resultSet = resultSet;
        this.target = target;
        this.propertyMetaDataList = propertyMetaDataList;
        this.isSingle = isSingle;
        this.config = config;
    }

    public <Key> Map<Key, T> createMap(String column) throws SQLException, NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        AbsBeanCreator<T> beanCreator = this.config.getFastCreatorFactory().get(this.target);
        Supplier<T> creator = beanCreator.getBeanCreator();
        Map<String, Integer> indexMap = this.getIndexMap();
        HashMap<Object, T> hashMap = new HashMap<Object, T>();
        while (this.resultSet.next()) {
            T t = creator.get();
            Object key = null;
            for (PropertyMetaData metaData : this.propertyMetaDataList) {
                Object value = this.convertValue(metaData, indexMap.get(metaData.getColumn()));
                if (column.equals(metaData.getColumn())) {
                    key = value;
                }
                if (value == null) continue;
                metaData.getSetter().invoke(t, value);
            }
            if (key == null) continue;
            hashMap.put(key, t);
        }
        return hashMap;
    }

    public <Key> Map<Key, List<T>> createMapList(String keyColumn) throws SQLException, NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        AbsBeanCreator<T> beanCreator = this.config.getFastCreatorFactory().get(this.target);
        Supplier<T> creator = beanCreator.getBeanCreator();
        Map<String, Integer> indexMap = this.getIndexMap();
        HashMap hashMap = new HashMap();
        while (this.resultSet.next()) {
            T t = creator.get();
            Object key = null;
            for (PropertyMetaData metaData : this.propertyMetaDataList) {
                String column = metaData.getColumn();
                Object value = this.convertValue(metaData, indexMap.get(column));
                if (keyColumn.equals(metaData.getColumn())) {
                    key = value;
                }
                if (value == null) continue;
                metaData.getSetter().invoke(t, value);
            }
            if (key == null) continue;
            if (!hashMap.containsKey(key)) {
                ArrayList<T> tempList = new ArrayList<T>();
                tempList.add(t);
                hashMap.put(key, tempList);
                continue;
            }
            ((List)hashMap.get(key)).add(t);
        }
        return hashMap;
    }

    public <Key> Map<Key, List<T>> createMapListByAnotherKey(PropertyMetaData anotherKeyColumn) throws SQLException, NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        AbsBeanCreator<T> beanCreator = this.config.getFastCreatorFactory().get(this.target);
        Supplier<T> creator = beanCreator.getBeanCreator();
        Map<String, Integer> indexMap = this.getIndexMap();
        int anotherKeyIndex = indexMap.get(anotherKeyColumn.getColumn());
        HashMap hashMap = new HashMap();
        while (this.resultSet.next()) {
            T t = creator.get();
            Object key = this.convertValue(anotherKeyColumn, anotherKeyIndex);
            for (PropertyMetaData metaData : this.propertyMetaDataList) {
                Object value = this.convertValue(metaData, indexMap.get(metaData.getColumn()));
                if (value == null) continue;
                metaData.getSetter().invoke(t, value);
            }
            if (!hashMap.containsKey(key)) {
                ArrayList<T> tempList = new ArrayList<T>();
                tempList.add(t);
                hashMap.put(key, tempList);
                continue;
            }
            ((List)hashMap.get(key)).add(t);
        }
        return hashMap;
    }

    public List<T> createList() throws SQLException, NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        if (this.isSingle) {
            return this.getSingleList();
        }
        return this.getClassList();
    }

    private List<T> getSingleList() throws SQLException, NoSuchFieldException, IllegalAccessException {
        ArrayList list = new ArrayList();
        ITypeHandler typeHandler = TypeHandlerManager.get(this.target);
        while (this.resultSet.next()) {
            Object t = typeHandler.getValue(this.resultSet, 1, this.target);
            list.add(t);
        }
        return list;
    }

    private List<T> getClassList() throws SQLException, NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        AbsBeanCreator<T> beanCreator = this.config.getFastCreatorFactory().get(this.target);
        Supplier<T> creator = beanCreator.getBeanCreator();
        Map<String, Integer> indexMap = this.getIndexMap();
        ArrayList<T> list = new ArrayList<T>();
        while (this.resultSet.next()) {
            T t = creator.get();
            for (PropertyMetaData metaData : this.propertyMetaDataList) {
                Object value = this.convertValue(metaData, indexMap.get(metaData.getColumn()));
                if (value == null) continue;
                ISetterCaller<T> beanSetter = beanCreator.getBeanSetter(metaData.getProperty());
                beanSetter.call(t, value);
            }
            list.add(t);
        }
        return list;
    }

    private Map<String, Integer> getIndexMap() throws SQLException {
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
        ResultSetMetaData resultSetMetaData = this.resultSet.getMetaData();
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            String columnLabel = resultSetMetaData.getColumnLabel(i);
            indexMap.put(columnLabel, i);
        }
        return indexMap;
    }

    private Object convertValue(PropertyMetaData metaData, int index) throws SQLException, NoSuchFieldException, IllegalAccessException {
        return metaData.getTypeHandler().getValue(this.resultSet, index, metaData.getType());
    }
}

