/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core.api.crud.create;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.noear.solon.data.sqlink.base.IConfig;
import org.noear.solon.data.sqlink.base.IDialect;
import org.noear.solon.data.sqlink.base.metaData.MetaData;
import org.noear.solon.data.sqlink.base.metaData.MetaDataCache;
import org.noear.solon.data.sqlink.base.metaData.PropertyMetaData;
import org.noear.solon.data.sqlink.base.session.SqlSession;
import org.noear.solon.data.sqlink.core.api.crud.CRUD;
import org.noear.solon.data.sqlink.core.sqlBuilder.InsertSqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InsertBase
extends CRUD {
    public static final Logger log = LoggerFactory.getLogger(InsertBase.class);
    private final InsertSqlBuilder sqlBuilder;

    protected InsertSqlBuilder getSqlBuilder() {
        return this.sqlBuilder;
    }

    @Override
    protected IConfig getConfig() {
        return this.sqlBuilder.getConfig();
    }

    public InsertBase(IConfig c) {
        this.sqlBuilder = new InsertSqlBuilder(c);
    }

    public long executeRows() {
        List<Object> objects = this.getObjects();
        if (!objects.isEmpty()) {
            return this.objectsExecuteRows(objects);
        }
        return 0L;
    }

    @Override
    public String toSql() {
        List objects = this.getObjects();
        if (!objects.isEmpty()) {
            return this.makeByObjects();
        }
        return this.sqlBuilder.getSql();
    }

    protected <T> List<T> getObjects() {
        return Collections.emptyList();
    }

    protected abstract <T> Class<T> getTableType();

    private long objectsExecuteRows(List<Object> objects) {
        IConfig config = this.getConfig();
        String sql = this.makeByObjects();
        this.tryPrintSql(log, sql);
        SqlSession session = config.getSqlSessionFactory().getSession();
        if (objects.size() > 1) {
            this.tryPrintBatch(log, objects.size());
        } else {
            this.tryPrintNoBatch(log, objects.size());
        }
        return session.executeInsert(sql, objects);
    }

    private String makeByObjects() {
        MetaData metaData = MetaDataCache.getMetaData(this.getTableType());
        ArrayList<String> tableFields = new ArrayList<String>();
        ArrayList<String> tableValues = new ArrayList<String>();
        for (PropertyMetaData propertyMetaData : metaData.getNotIgnorePropertys()) {
            if (propertyMetaData.isPrimaryKey()) continue;
            tableFields.add(propertyMetaData.getColumn());
            tableValues.add("?");
        }
        IDialect dialect = this.getSqlBuilder().getConfig().getDisambiguation();
        return "INSERT INTO " + dialect.disambiguationTableName(metaData.getTableName()) + "(" + String.join((CharSequence)",", tableFields) + ") VALUES(" + String.join((CharSequence)",", tableValues) + ")";
    }
}

