/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.plugin.aot.service;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TaskEvent;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import io.github.kiryu1223.expressionTree.expressions.annos.Getter;
import io.github.kiryu1223.expressionTree.expressions.annos.Recode;
import io.github.kiryu1223.expressionTree.expressions.annos.Setter;
import io.github.kiryu1223.expressionTree.ext.IExtensionService;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.noear.snack.ONode;
import org.noear.snack.core.Feature;
import org.noear.snack.core.Options;
import org.noear.solon.data.sqlink.base.metaData.IConverter;
import org.noear.solon.data.sqlink.plugin.aot.data.AnonymousClassData;
import org.noear.solon.data.sqlink.plugin.aot.data.ClassData;
import org.noear.solon.data.sqlink.plugin.aot.data.NormalClassData;

public class SQLinkExtensionService
implements IExtensionService {
    private static final String projectVersion = "1.0.14";
    private FileObject aotConfig;
    private boolean aotTime;
    private Set<String> AnonymousClassesName = new HashSet<String>();
    private Set<String> classesName = new HashSet<String>();
    private boolean isWrite = false;

    public void init(Context context) {
        this.checkAot(context);
        if (!this.aotTime) {
            return;
        }
        try {
            this.createAotFile(context);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkAot(Context context) {
        com.sun.tools.javac.util.Options options = com.sun.tools.javac.util.Options.instance(context);
        String aot = options.get("-Aot");
        this.aotTime = aot != null;
    }

    private void createAotFile(Context context) throws IOException {
        Filer filer = JavacProcessingEnvironment.instance(context).getFiler();
        this.aotConfig = filer.createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/native-image/io/github/kiryu1223/SQLink/1.0.14/reflect-config.json", new Element[0]);
    }

    public void started(TaskEvent event) throws Throwable {
        if (!this.aotTime) {
            return;
        }
    }

    public void finished(TaskEvent event) throws Throwable {
        if (!this.aotTime) {
            return;
        }
        this.recodeClasses(event);
        this.writeData(event);
    }

    private void recodeClasses(TaskEvent event) {
        if (event.getKind() != TaskEvent.Kind.ANALYZE) {
            return;
        }
        String sourceFileName = event.getSourceFile().getName();
        CompilationUnitTree compilationUnit = event.getCompilationUnit();
        block0: for (Tree tree : compilationUnit.getTypeDecls()) {
            if (!(tree instanceof JCTree.JCClassDecl)) continue;
            JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)tree;
            classDecl.accept(new TreeScanner(){

                @Override
                public void visitNewClass(JCTree.JCNewClass newClass) {
                    if (newClass.getClassBody() != null) {
                        JCTree.JCClassDecl classBody = newClass.getClassBody();
                        Symbol.ClassSymbol classSymbol = classBody.getExtendsClause().type.asElement().enclClass();
                        Getter getter = classSymbol.getAnnotation(Getter.class);
                        Setter setter = classSymbol.getAnnotation(Setter.class);
                        if (getter != null || setter != null) {
                            SQLinkExtensionService.this.AnonymousClassesName.add(classBody.sym.flatName().toString());
                        }
                    } else {
                        super.visitNewClass(newClass);
                    }
                }

                @Override
                public void visitApply(JCTree.JCMethodInvocation methodInvocation) {
                    Symbol.MethodSymbol methodSymbol;
                    JCTree.JCExpression select;
                    JCTree.JCExpression methodSelect = methodInvocation.getMethodSelect();
                    if (methodSelect instanceof JCTree.JCFieldAccess) {
                        select = (JCTree.JCFieldAccess)methodSelect;
                        methodSymbol = (Symbol.MethodSymbol)select.sym;
                    } else {
                        select = (JCTree.JCIdent)methodSelect;
                        methodSymbol = (Symbol.MethodSymbol)((JCTree.JCIdent)select).sym;
                    }
                    for (int i = 0; i < ((List)methodSymbol.getParameters()).size(); ++i) {
                        Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)((List)methodSymbol.getParameters()).get(i);
                        if (varSymbol.getAnnotation(Recode.class) == null) continue;
                        JCTree.JCExpression arg = (JCTree.JCExpression)((List)methodInvocation.getArguments()).get(i);
                        if (arg.type instanceof Type.ClassType) {
                            Type.ClassType classType = (Type.ClassType)arg.type;
                            Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)classType.tsym;
                            if (!classType.isParameterized()) {
                                if (classSymbol.isAnonymous()) continue;
                                SQLinkExtensionService.this.classesName.add(classSymbol.flatName().toString());
                                continue;
                            }
                            Type type = (Type)((List)classType.getTypeArguments()).get(0);
                            if (type instanceof Type.ClassType) {
                                Type.ClassType t1Type = (Type.ClassType)type;
                                Element element = t1Type.asElement();
                                if (((Symbol)element).isAnonymous()) continue;
                                SQLinkExtensionService.this.classesName.add(((Symbol)element).flatName().toString());
                                continue;
                            }
                            if (!(type instanceof Type.CapturedType)) continue;
                            Type.CapturedType capturedType = (Type.CapturedType)type;
                            SQLinkExtensionService.this.classesName.add(capturedType.wildcard.type.asElement().flatName().toString());
                            continue;
                        }
                        System.out.println(arg);
                        System.out.println(arg.type);
                    }
                    super.visitApply(methodInvocation);
                }
            });
            if (((List)classDecl.getImplementsClause()).isEmpty()) continue;
            for (JCTree.JCExpression jcExpression : classDecl.getImplementsClause()) {
                if (!jcExpression.type.asElement().flatName().toString().equals(IConverter.class.getCanonicalName())) continue;
                this.classesName.add(classDecl.sym.flatName().toString());
                Type.ClassType classType = (Type.ClassType)jcExpression.type;
                for (Type typeArgument : classType.getTypeArguments()) {
                    String typeName = typeArgument.asElement().flatName().toString();
                    if (typeName.startsWith("java")) continue;
                    this.classesName.add(typeName);
                }
                continue block0;
            }
        }
    }

    private void writeData(TaskEvent event) throws IOException {
        if (event.getKind().name().equals("COMPILATION") && !this.isWrite) {
            this.isWrite = true;
            ArrayList<ClassData> classDataList = new ArrayList<ClassData>(this.classesName.size() + this.AnonymousClassesName.size());
            for (String name : this.classesName) {
                classDataList.add(new NormalClassData(name));
            }
            for (String name : this.AnonymousClassesName) {
                classDataList.add(new AnonymousClassData(name));
            }
            String stringify = ONode.stringify(classDataList, (Options)Options.def().add(new Feature[]{Feature.PrettyFormat}));
            Writer writer = this.aotConfig.openWriter();
            writer.write(stringify);
            writer.flush();
            writer.close();
        }
    }
}

