/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core.sqlExt.pgsql;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.noear.solon.data.sqlink.base.DbType;
import org.noear.solon.data.sqlink.base.IConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSingleValueExpression;
import org.noear.solon.data.sqlink.base.sqlExt.BaseSqlExtension;
import org.noear.solon.data.sqlink.core.exception.SQLinkIntervalException;

public class PostgreSQLAddOrSubDateExtension
extends BaseSqlExtension {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ISqlExpression parse(IConfig config, Method sqlFunc, List<ISqlExpression> args) {
        ArrayList<String> templates = new ArrayList<String>();
        ArrayList<ISqlExpression> sqlExpressions = new ArrayList<ISqlExpression>();
        boolean isPlus = sqlFunc.getName().equals("addDate");
        if (isPlus) {
            templates.add("DATE_ADD(");
        } else {
            templates.add("DATE_SUBTRACT(");
        }
        sqlExpressions.add(args.get(0));
        if (sqlFunc.getParameterCount() == 2) {
            ISqlExpression num = args.get(1);
            if (!(num instanceof ISqlSingleValueExpression)) throw new SQLinkIntervalException(DbType.PostgreSQL);
            ISqlSingleValueExpression valueExpression = (ISqlSingleValueExpression)num;
            templates.add(",INTERVAL '" + valueExpression.getValue() + "' DAY)");
            return config.getSqlExpressionFactory().template(templates, sqlExpressions);
        } else {
            ISqlExpression num = args.get(2);
            if (!(num instanceof ISqlSingleValueExpression)) throw new SQLinkIntervalException(DbType.PostgreSQL);
            ISqlSingleValueExpression valueExpression = (ISqlSingleValueExpression)num;
            templates.add(",INTERVAL '" + valueExpression.getValue() + "' ");
            sqlExpressions.add(args.get(1));
            templates.add(")");
        }
        return config.getSqlExpressionFactory().template(templates, sqlExpressions);
    }
}

