/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core.sqlBuilder;

import java.util.ArrayList;
import java.util.List;
import org.noear.solon.data.sqlink.base.IConfig;
import org.noear.solon.data.sqlink.base.IDialect;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlJoinExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlJoinsExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSetExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSetsExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlTableExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlWhereExpression;
import org.noear.solon.data.sqlink.base.expression.JoinType;
import org.noear.solon.data.sqlink.base.expression.SqlExpressionFactory;
import org.noear.solon.data.sqlink.base.metaData.MetaData;
import org.noear.solon.data.sqlink.base.metaData.MetaDataCache;
import org.noear.solon.data.sqlink.core.sqlBuilder.ISqlBuilder;

public class UpdateSqlBuilder
implements ISqlBuilder {
    private final IConfig config;
    private final ISqlJoinsExpression joins;
    private final ISqlSetsExpression sets;
    private final ISqlWhereExpression wheres;
    private final Class<?> target;
    private final SqlExpressionFactory factory;

    public UpdateSqlBuilder(IConfig config, Class<?> target) {
        this.config = config;
        this.target = target;
        this.factory = config.getSqlExpressionFactory();
        this.joins = this.factory.Joins();
        this.sets = this.factory.sets();
        this.wheres = this.factory.where();
    }

    public void addJoin(Class<?> target, JoinType joinType, ISqlTableExpression table, ISqlExpression on) {
        ISqlJoinExpression join = this.factory.join(joinType, table, on, 1 + this.joins.getJoins().size());
        this.joins.addJoin(join);
    }

    public void addSet(ISqlSetsExpression set) {
        this.sets.addSet(set.getSets());
    }

    public void addSet(ISqlSetExpression set) {
        this.sets.addSet(set);
    }

    public void addWhere(ISqlExpression where) {
        this.wheres.addCondition(where);
    }

    public boolean hasWhere() {
        return !this.wheres.isEmpty();
    }

    @Override
    public String getSql() {
        return this.makeUpdate();
    }

    @Override
    public String getSqlAndValue(List<Object> values) {
        return this.makeUpdate();
    }

    @Override
    public IConfig getConfig() {
        return this.config;
    }

    private String makeUpdate() {
        MetaData metaData = MetaDataCache.getMetaData(this.target);
        IDialect dbConfig = this.config.getDisambiguation();
        String sql = "UPDATE " + dbConfig.disambiguationTableName(metaData.getTableName()) + " AS t0";
        StringBuilder sb = new StringBuilder();
        sb.append(sql);
        String joinsSqlAndValue = this.joins.getSql(this.config);
        if (!joinsSqlAndValue.isEmpty()) {
            sb.append(" ").append(joinsSqlAndValue);
        }
        String setsSqlAndValue = this.sets.getSql(this.config);
        sb.append(" ").append(setsSqlAndValue);
        String wheresSqlAndValue = this.wheres.getSql(this.config);
        if (!wheresSqlAndValue.isEmpty()) {
            sb.append(" ").append(wheresSqlAndValue);
        }
        return sb.toString();
    }

    private String makeUpdate(List<Object> values) {
        MetaData metaData = MetaDataCache.getMetaData(this.target);
        IDialect dbConfig = this.config.getDisambiguation();
        String sql = "UPDATE " + dbConfig.disambiguationTableName(metaData.getTableName()) + " AS t0";
        ArrayList<String> sb = new ArrayList<String>();
        sb.add(sql);
        String joinsSqlAndValue = this.joins.getSqlAndValue(this.config, values);
        if (!joinsSqlAndValue.isEmpty()) {
            sb.add(joinsSqlAndValue);
        }
        String setsSqlAndValue = this.sets.getSqlAndValue(this.config, values);
        sb.add(setsSqlAndValue);
        String wheresSqlAndValue = this.wheres.getSqlAndValue(this.config, values);
        if (!wheresSqlAndValue.isEmpty()) {
            sb.add(wheresSqlAndValue);
        }
        return String.join((CharSequence)" ", sb);
    }
}

