/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.base.session;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.List;
import org.noear.solon.data.sqlink.base.dataSource.DataSourceManager;
import org.noear.solon.data.sqlink.base.session.SqlSession;
import org.noear.solon.data.sqlink.base.session.SqlValue;
import org.noear.solon.data.sqlink.base.transaction.TransactionManager;

public class DefaultSqlSession
implements SqlSession {
    protected final DataSourceManager dataSourceManager;
    protected final TransactionManager transactionManager;

    public DefaultSqlSession(DataSourceManager dataSourceManager, TransactionManager transactionManager) {
        this.dataSourceManager = dataSourceManager;
        this.transactionManager = transactionManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <R> R executeQuery(SqlSession.Function<ResultSet, R> func, String sql, Collection<Object> values) {
        if (!this.transactionManager.currentThreadInTransaction()) {
            try (Connection connection = this.dataSourceManager.getConnection();){
                R r = this.executeQuery(connection, func, sql, values);
                return r;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Connection connection;
            if (this.transactionManager.isOpenTransaction()) {
                connection = this.transactionManager.getCurTransaction().getConnection();
                return this.executeQuery(connection, func, sql, values);
            }
            connection = this.dataSourceManager.getConnection();
            return this.executeQuery(connection, func, sql, values);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Exception decompiling
     */
    private <R> R executeQuery(Connection connection, SqlSession.Function<ResultSet, R> func, String sql, Collection<Object> values) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long executeUpdate(String sql, List<SqlValue> values) {
        if (!this.transactionManager.currentThreadInTransaction()) {
            try (Connection connection = this.dataSourceManager.getConnection();){
                long l = this.executeUpdate(connection, sql, values);
                return l;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Connection connection;
            if (this.transactionManager.isOpenTransaction()) {
                connection = this.transactionManager.getCurTransaction().getConnection();
                return this.executeUpdate(connection, sql, values);
            }
            connection = this.dataSourceManager.getConnection();
            return this.executeUpdate(connection, sql, values);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long executeUpdate(String sql, List<Object> values, Object ... o) {
        if (!this.transactionManager.currentThreadInTransaction()) {
            try (Connection connection = this.dataSourceManager.getConnection();){
                long l = this.executeUpdate(connection, sql, values, new Object[0]);
                return l;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Connection connection;
            if (this.transactionManager.isOpenTransaction()) {
                connection = this.transactionManager.getCurTransaction().getConnection();
                return this.executeUpdate(connection, sql, values, new Object[0]);
            }
            connection = this.dataSourceManager.getConnection();
            return this.executeUpdate(connection, sql, values, new Object[0]);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long batchExecuteUpdate(String sql, long limit, List<SqlValue> values) {
        if (!this.transactionManager.currentThreadInTransaction()) {
            try (Connection connection = this.dataSourceManager.getConnection();){
                long l = this.batchExecuteUpdate(connection, sql, limit, values);
                return l;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Connection connection;
            if (this.transactionManager.isOpenTransaction()) {
                connection = this.transactionManager.getCurTransaction().getConnection();
                return this.batchExecuteUpdate(connection, sql, limit, values);
            }
            connection = this.dataSourceManager.getConnection();
            return this.batchExecuteUpdate(connection, sql, limit, values);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long executeUpdate(Connection connection, String sql, List<SqlValue> values) {
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            this.setObjectsIfNull(preparedStatement, values);
            long l = preparedStatement.executeUpdate();
            return l;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long executeUpdate(Connection connection, String sql, Collection<Object> values, Object ... o) {
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            this.setObjects(preparedStatement, values);
            long l = preparedStatement.executeUpdate();
            return l;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long batchExecuteUpdate(Connection connection, String sql, long limit, List<SqlValue> values) {
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            this.batchSetObjects(preparedStatement, limit, values);
            long l = preparedStatement.executeBatch().length;
            return l;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected void setObjects(PreparedStatement preparedStatement, Collection<Object> values) throws SQLException {
        int index = 1;
        for (Object value : values) {
            if (value instanceof Enum) {
                preparedStatement.setString(index++, value.toString());
                continue;
            }
            if (value instanceof Character) {
                preparedStatement.setString(index++, value.toString());
                continue;
            }
            if (value instanceof Integer) {
                preparedStatement.setInt(index++, (Integer)value);
                continue;
            }
            if (value instanceof String) {
                preparedStatement.setString(index++, value.toString());
                continue;
            }
            preparedStatement.setObject(index++, value);
        }
    }

    protected void setObjectsIfNull(PreparedStatement preparedStatement, List<SqlValue> values) throws SQLException {
        for (int i = 1; i <= values.size(); ++i) {
            SqlValue value = values.get(i - 1);
            Object o = value.getValues().get(0);
            if (o == null) {
                preparedStatement.setNull(i, DefaultSqlSession.convert(value.getType()));
                continue;
            }
            preparedStatement.setObject(i, o);
        }
    }

    protected void batchSetObjects(PreparedStatement preparedStatement, long limit, List<SqlValue> values) throws SQLException {
        for (long i = 0L; i < limit; ++i) {
            int index = 0;
            for (SqlValue value : values) {
                Object o = value.getValues().get((int)i);
                if (o == null) {
                    preparedStatement.setNull(++index, DefaultSqlSession.convert(value.getType()));
                    continue;
                }
                preparedStatement.setObject(++index, o);
            }
            preparedStatement.addBatch();
        }
    }

    protected static int convert(Class<?> type) {
        if (type == String.class) {
            return 12;
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return 4;
        }
        if (type == Long.class || type == Long.TYPE) {
            return -5;
        }
        if (type == Double.class || type == Double.TYPE) {
            return 8;
        }
        if (type == Float.class || type == Float.TYPE) {
            return 6;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return 16;
        }
        if (type == Date.class || type == LocalDate.class) {
            return 91;
        }
        if (type == Time.class || type == LocalTime.class) {
            return 92;
        }
        if (type == Timestamp.class || type == LocalDateTime.class) {
            return 93;
        }
        if (type == BigDecimal.class) {
            return 3;
        }
        return 1111;
    }
}

