/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.base.expression.impl;

import java.util.List;
import org.noear.solon.data.sqlink.base.IConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlColumnExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSetExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSingleValueExpression;
import org.noear.solon.data.sqlink.base.metaData.PropertyMetaData;

public class SqlSetExpression
implements ISqlSetExpression {
    private final ISqlColumnExpression column;
    private final ISqlExpression value;

    SqlSetExpression(ISqlColumnExpression column, ISqlExpression value) {
        this.column = column;
        this.value = value;
    }

    @Override
    public ISqlColumnExpression getColumn() {
        return this.column;
    }

    @Override
    public ISqlExpression getValue() {
        return this.value;
    }

    @Override
    public String getSqlAndValue(IConfig config, List<Object> values) {
        String set = this.getColumn().getSqlAndValue(config, values) + " = ";
        PropertyMetaData propertyMetaData = this.getColumn().getPropertyMetaData();
        if (propertyMetaData.hasConverter() && this.getValue() instanceof ISqlSingleValueExpression) {
            ISqlSingleValueExpression sqlSingleValueExpression = (ISqlSingleValueExpression)this.getValue();
            return set + sqlSingleValueExpression.getSqlAndValue(config, values, propertyMetaData.getConverter(), propertyMetaData);
        }
        return set + this.getValue().getSqlAndValue(config, values);
    }
}

