/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.dynamicds;

import org.noear.solon.core.FactoryManager;
import org.noear.solon.core.util.RunnableEx;
import org.noear.solon.core.util.SupplierEx;

public class DynamicDsKey {
    static ThreadLocal<String> targetThreadLocal = FactoryManager.getGlobal().newThreadLocal(DynamicDsKey.class, false);

    public static void remove() {
        targetThreadLocal.remove();
    }

    public static String current() {
        return targetThreadLocal.get();
    }

    public static void use(String name) {
        if (name == null) {
            targetThreadLocal.remove();
        } else {
            targetThreadLocal.set(name);
        }
    }

    public static void use(String name, RunnableEx runnable) throws Throwable {
        try {
            targetThreadLocal.set(name);
            runnable.run();
        }
        finally {
            targetThreadLocal.remove();
        }
    }

    public static <T> T use(String name, SupplierEx<T> supplier) throws Throwable {
        try {
            targetThreadLocal.set(name);
            Object object = supplier.get();
            return (T)object;
        }
        finally {
            targetThreadLocal.remove();
        }
    }

    @Deprecated
    public static String getCurrent() {
        return DynamicDsKey.current();
    }

    @Deprecated
    public static void setCurrent(String name) {
        DynamicDsKey.use(name);
    }
}

