/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.metrics.integration;

import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.noear.solon.cloud.service.CloudMetricService;

public class CloudMetricServiceImpl
implements CloudMetricService {
    public void addCounter(String group, String category, String item, long increment, Map<String, String> attrs) {
        StringBuilder buf = new StringBuilder();
        buf.append(group).append(".").append(category).append(".").append(item);
        Metrics.counter((String)buf.toString(), this.getTags(attrs)).increment((double)increment);
    }

    public void addTimer(String group, String category, String item, long record, Map<String, String> attrs) {
        StringBuilder buf = new StringBuilder();
        buf.append(group).append(".").append(category).append(".").append(item);
        Metrics.timer((String)buf.toString(), this.getTags(attrs)).record(record, TimeUnit.MILLISECONDS);
    }

    public void addGauge(String group, String category, String item, long number, Map<String, String> attrs) {
        StringBuilder buf = new StringBuilder();
        buf.append(group).append(".").append(category).append(".").append(item);
        Metrics.gauge((String)buf.toString(), this.getTags(attrs), (Number)number);
    }

    protected Iterable<Tag> getTags(Map<String, String> tags) {
        ArrayList<Tag> tagList = new ArrayList<Tag>();
        if (tags != null) {
            for (Map.Entry<String, String> kv : tags.entrySet()) {
                tagList.add(Tag.of((String)kv.getKey(), (String)kv.getValue()));
            }
        }
        return tagList;
    }
}

