/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.metrics.interceptor;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.noear.solon.Utils;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.aspect.Invocation;
import org.noear.solon.core.handle.Context;

public abstract class BaseMeterInterceptor<T, M>
implements Interceptor {
    private final Map<String, M> meterCached = new ConcurrentHashMap<String, M>();

    protected abstract T getAnno(Invocation var1);

    protected abstract String getAnnoName(T var1);

    protected abstract Object metering(Invocation var1, T var2) throws Throwable;

    public Object doIntercept(Invocation inv) throws Throwable {
        T anno = this.getAnno(inv);
        if (anno != null) {
            return this.metering(inv, anno);
        }
        return inv.invoke();
    }

    protected M getMeter(String meterName, Supplier<M> supplier) {
        Object tmp = this.meterCached.computeIfAbsent(meterName, k -> supplier.get());
        return (M)tmp;
    }

    protected String getMeterName(Invocation inv, T anno) {
        String meterName = this.getAnnoName(anno);
        if (Utils.isEmpty((String)meterName)) {
            meterName = inv.target().getClass().getName() + "::" + inv.method().getMethod().getName();
        }
        return meterName;
    }

    protected Tags getMeterTags(Invocation inv, String[] annoTags) {
        Tags tags = Tags.of((String[])annoTags);
        Context ctx = Context.current();
        if (ctx != null) {
            tags.and(new Tag[]{Tag.of((String)"uri", (String)ctx.path()), Tag.of((String)"method", (String)ctx.method()), Tag.of((String)"class", (String)inv.target().getClass().getTypeName()), Tag.of((String)"executable", (String)inv.method().getMethod().getName())});
        } else {
            tags.and(new Tag[]{Tag.of((String)"class", (String)inv.target().getClass().getTypeName()), Tag.of((String)"executable", (String)inv.method().getMethod().getName())});
        }
        return tags;
    }
}

