/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.route;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.cloud.gateway.exchange.ExFilter;
import org.noear.solon.cloud.gateway.exchange.ExPredicate;
import org.noear.solon.cloud.gateway.route.RouteFilterFactory;
import org.noear.solon.cloud.gateway.route.RouteHandler;
import org.noear.solon.cloud.gateway.route.RoutePredicateFactory;
import org.noear.solon.cloud.gateway.route.filter.AddRequestHeaderFilterFactory;
import org.noear.solon.cloud.gateway.route.filter.AddResponseHeaderFilterFactory;
import org.noear.solon.cloud.gateway.route.filter.PrefixPathFilterFactory;
import org.noear.solon.cloud.gateway.route.filter.RedirectToFilterFactory;
import org.noear.solon.cloud.gateway.route.filter.RemoveRequestHeaderFilterFactory;
import org.noear.solon.cloud.gateway.route.filter.RemoveResponseHeaderFilterFactory;
import org.noear.solon.cloud.gateway.route.filter.RewritePathFilterFactory;
import org.noear.solon.cloud.gateway.route.filter.StripPrefixFilterFactory;
import org.noear.solon.cloud.gateway.route.handler.HttpRouteHandler;
import org.noear.solon.cloud.gateway.route.handler.LbRouteHandler;
import org.noear.solon.cloud.gateway.route.predicate.AfterPredicateFactory;
import org.noear.solon.cloud.gateway.route.predicate.BeforePredicateFactory;
import org.noear.solon.cloud.gateway.route.predicate.CookiePredicateFactory;
import org.noear.solon.cloud.gateway.route.predicate.HeaderPredicateFactory;
import org.noear.solon.cloud.gateway.route.predicate.HostPredicateFactory;
import org.noear.solon.cloud.gateway.route.predicate.MethodPredicateFactory;
import org.noear.solon.cloud.gateway.route.predicate.PathPredicateFactory;
import org.noear.solon.cloud.gateway.route.predicate.QueryPredicateFactory;
import org.noear.solon.cloud.gateway.route.predicate.RemoteAddrPredicateFactory;
import org.noear.solon.core.util.RankEntity;
import org.noear.solon.lang.Nullable;

public class RouteFactoryManager {
    private static final RouteFactoryManager global = new RouteFactoryManager();
    private Map<String, RouteFilterFactory> filterFactoryMap = new HashMap<String, RouteFilterFactory>();
    private Map<String, RoutePredicateFactory> predicateFactoryMap = new HashMap<String, RoutePredicateFactory>();
    private Map<String, RouteHandler> handlerMap = new HashMap<String, RouteHandler>();

    private RouteFactoryManager() {
    }

    public static void addFactory(RouteFilterFactory factory) {
        RouteFactoryManager.global.filterFactoryMap.put(factory.prefix(), factory);
    }

    public static void addFactory(RoutePredicateFactory factory) {
        RouteFactoryManager.global.predicateFactoryMap.put(factory.prefix(), factory);
    }

    public static void addHandler(RouteHandler handler) {
        for (String s1 : handler.schemas()) {
            RouteFactoryManager.global.handlerMap.put(s1, handler);
        }
    }

    public static RouteHandler getHandler(String schema) {
        return RouteFactoryManager.global.handlerMap.get(schema);
    }

    public static ExFilter getFilter(String prefix, String config) {
        RouteFilterFactory factory = RouteFactoryManager.global.filterFactoryMap.get(prefix);
        if (factory == null) {
            return null;
        }
        return factory.create(config);
    }

    public static ExPredicate getPredicate(String prefix, String config) {
        RoutePredicateFactory factory = RouteFactoryManager.global.predicateFactoryMap.get(prefix);
        if (factory == null) {
            return null;
        }
        return factory.create(config);
    }

    @Nullable
    public static ExPredicate buildPredicate(String predicateConfig) {
        if (Utils.isEmpty((String)predicateConfig)) {
            return null;
        }
        int idx = predicateConfig.indexOf(61);
        if (idx > 0) {
            String prefix = predicateConfig.substring(0, idx);
            String config = predicateConfig.substring(idx + 1, predicateConfig.length());
            return RouteFactoryManager.getPredicate(prefix, config);
        }
        return null;
    }

    @Nullable
    public static ExFilter buildFilter(String filterConfig) {
        if (Utils.isEmpty((String)filterConfig)) {
            return null;
        }
        int idx = filterConfig.indexOf(61);
        if (idx > 0) {
            String prefix = filterConfig.substring(0, idx);
            String config = filterConfig.substring(idx + 1, filterConfig.length());
            return RouteFactoryManager.getFilter(prefix, config);
        }
        return null;
    }

    public static List<RankEntity<ExFilter>> buildFilterList(String ... filterConfigs) throws IllegalArgumentException {
        if (filterConfigs.length == 0) {
            throw new IllegalArgumentException("ExFilter configs is empty");
        }
        ArrayList<RankEntity<ExFilter>> filters = new ArrayList<RankEntity<ExFilter>>();
        int filterIdx = 0;
        for (String c1 : filterConfigs) {
            ExFilter filter = RouteFactoryManager.buildFilter(c1);
            if (filter == null) {
                throw new IllegalArgumentException("ExFilter config wrong: " + c1);
            }
            filters.add((RankEntity<ExFilter>)new RankEntity((Object)filter, filterIdx++));
        }
        return filters;
    }

    static {
        RouteFactoryManager.addFactory(new AfterPredicateFactory());
        RouteFactoryManager.addFactory(new BeforePredicateFactory());
        RouteFactoryManager.addFactory(new CookiePredicateFactory());
        RouteFactoryManager.addFactory(new HeaderPredicateFactory());
        RouteFactoryManager.addFactory(new HostPredicateFactory());
        RouteFactoryManager.addFactory(new MethodPredicateFactory());
        RouteFactoryManager.addFactory(new PathPredicateFactory());
        RouteFactoryManager.addFactory(new QueryPredicateFactory());
        RouteFactoryManager.addFactory(new RemoteAddrPredicateFactory());
        RouteFactoryManager.addFactory(new AddRequestHeaderFilterFactory());
        RouteFactoryManager.addFactory(new AddResponseHeaderFilterFactory());
        RouteFactoryManager.addFactory(new PrefixPathFilterFactory());
        RouteFactoryManager.addFactory(new RedirectToFilterFactory());
        RouteFactoryManager.addFactory(new RewritePathFilterFactory());
        RouteFactoryManager.addFactory(new RemoveRequestHeaderFilterFactory());
        RouteFactoryManager.addFactory(new RemoveResponseHeaderFilterFactory());
        RouteFactoryManager.addFactory(new StripPrefixFilterFactory());
        RouteFactoryManager.addHandler(new HttpRouteHandler());
        RouteFactoryManager.addHandler(new LbRouteHandler());
    }
}

